/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.image;

import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.elementa.utils.ImageKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgg/essential/elementa/components/image/DefaultLoadingImage;", "Lgg/essential/elementa/components/image/ImageProvider;", "()V", "loadingImage", "Ljava/awt/image/BufferedImage;", "loadingTexture", "Lgg/essential/universal/utils/ReleasedDynamicTexture;", "drawImage", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "x", "", "y", "width", "height", "color", "Ljava/awt/Color;", "MSCore"})
public final class DefaultLoadingImage
implements ImageProvider {
    @NotNull
    public static final DefaultLoadingImage INSTANCE = new DefaultLoadingImage();
    @Nullable
    private static BufferedImage loadingImage = ImageIO.read(UMinecraft.getInputStream(new ResourceLocation("mscore", "textures/loading.png")));
    private static ReleasedDynamicTexture loadingTexture;

    private DefaultLoadingImage() {
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        ReleasedDynamicTexture releasedDynamicTexture;
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (loadingTexture == null) {
            BufferedImage bufferedImage = loadingImage;
            Intrinsics.checkNotNull((Object)bufferedImage);
            ReleasedDynamicTexture releasedDynamicTexture2 = UGraphics.getTexture(bufferedImage);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)releasedDynamicTexture2), (String)"getTexture(...)");
            loadingTexture = releasedDynamicTexture2;
            loadingImage = null;
        }
        if ((releasedDynamicTexture = loadingTexture) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingTexture");
            releasedDynamicTexture = null;
        }
        ImageKt.drawTexture(matrixStack, releasedDynamicTexture, color, x, y, width, height, 9729, 9729);
    }

    @Override
    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawImage(matrixStack, x, y, width, height, color)", imports={}))
    public void drawImage(double x, double y, double width, double height, @NotNull Color color) {
        ImageProvider.DefaultImpls.drawImage(this, x, y, width, height, color);
    }

    @Override
    public void drawImageCompat(@NotNull UMatrixStack matrixStack, double x, double y, double width, double height, @NotNull Color color) {
        ImageProvider.DefaultImpls.drawImageCompat(this, matrixStack, x, y, width, height, color);
    }
}

