/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.image;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B)\b\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JL\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006 "}, d2={"Lgg/essential/elementa/components/image/ImageComponent;", "Lgg/essential/elementa/UIComponent;", "path", "Lnet/minecraft/resources/ResourceLocation;", "texMinFilter", "Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "texMagFilter", "(Lnet/minecraft/resources/ResourceLocation;Lgg/essential/elementa/components/UIImage$TextureScalingMode;Lgg/essential/elementa/components/UIImage$TextureScalingMode;)V", "pathState", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;Lgg/essential/elementa/components/UIImage$TextureScalingMode;Lgg/essential/elementa/components/UIImage$TextureScalingMode;)V", "getPathState", "()Lgg/essential/elementa/state/State;", "getTexMagFilter", "()Lgg/essential/elementa/components/UIImage$TextureScalingMode;", "getTexMinFilter", "bindPath", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawImage", "color", "Ljava/awt/Color;", "x", "", "y", "width", "height", "textureMinFilter", "", "textureMagFilter", "MSCore"})
public class ImageComponent
extends UIComponent {
    @NotNull
    private final State<ResourceLocation> pathState;
    @NotNull
    private final UIImage.TextureScalingMode texMinFilter;
    @NotNull
    private final UIImage.TextureScalingMode texMagFilter;

    @JvmOverloads
    public ImageComponent(@NotNull State<ResourceLocation> pathState, @NotNull UIImage.TextureScalingMode texMinFilter, @NotNull UIImage.TextureScalingMode texMagFilter) {
        Intrinsics.checkNotNullParameter(pathState, (String)"pathState");
        Intrinsics.checkNotNullParameter((Object)((Object)texMinFilter), (String)"texMinFilter");
        Intrinsics.checkNotNullParameter((Object)((Object)texMagFilter), (String)"texMagFilter");
        this.pathState = pathState;
        this.texMinFilter = texMinFilter;
        this.texMagFilter = texMagFilter;
    }

    public /* synthetic */ ImageComponent(State state, UIImage.TextureScalingMode textureScalingMode, UIImage.TextureScalingMode textureScalingMode2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textureScalingMode = UIImage.TextureScalingMode.LINEAR;
        }
        if ((n & 4) != 0) {
            textureScalingMode2 = UIImage.TextureScalingMode.LINEAR;
        }
        this(state, textureScalingMode, textureScalingMode2);
    }

    @NotNull
    public final State<ResourceLocation> getPathState() {
        return this.pathState;
    }

    @NotNull
    public final UIImage.TextureScalingMode getTexMinFilter() {
        return this.texMinFilter;
    }

    @NotNull
    public final UIImage.TextureScalingMode getTexMagFilter() {
        return this.texMagFilter;
    }

    @JvmOverloads
    public ImageComponent(@NotNull ResourceLocation path, @NotNull UIImage.TextureScalingMode texMinFilter, @NotNull UIImage.TextureScalingMode texMagFilter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)texMinFilter), (String)"texMinFilter");
        Intrinsics.checkNotNullParameter((Object)((Object)texMagFilter), (String)"texMagFilter");
        this((State<ResourceLocation>)new BasicState<ResourceLocation>(path), texMinFilter, texMagFilter);
    }

    public /* synthetic */ ImageComponent(ResourceLocation resourceLocation, UIImage.TextureScalingMode textureScalingMode, UIImage.TextureScalingMode textureScalingMode2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textureScalingMode = UIImage.TextureScalingMode.LINEAR;
        }
        if ((n & 4) != 0) {
            textureScalingMode2 = UIImage.TextureScalingMode.LINEAR;
        }
        this(resourceLocation, textureScalingMode, textureScalingMode2);
    }

    @NotNull
    public final ImageComponent bindPath(@NotNull ResourceLocation path) {
        ImageComponent imageComponent;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ImageComponent $this$bindPath_u24lambda_u240 = imageComponent = this;
        boolean bl = false;
        $this$bindPath_u24lambda_u240.pathState.set(path);
        return imageComponent;
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        this.drawImage(matrixStack, color, x, y, width, height, this.texMinFilter.getGlMode$MSCore(), this.texMagFilter.getGlMode$MSCore());
        super.draw(matrixStack);
    }

    private final void drawImage(UMatrixStack matrixStack, Color color, double x, double y, double width, double height, int textureMinFilter, int textureMagFilter) {
        matrixStack.push();
        UGraphics.enableBlend();
        UGraphics.enableAlpha();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
        UGraphics.bindTexture(0, this.pathState.get());
        matrixStack.scale(1.0f, 1.0f, 50.0f);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        GL11.glTexParameteri((int)3553, (int)10241, (int)textureMinFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)textureMagFilter);
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        worldRenderer.pos(matrixStack, x, y + height, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y + height, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha).endVertex();
        worldRenderer.drawDirect();
        matrixStack.pop();
    }

    static /* synthetic */ void drawImage$default(ImageComponent imageComponent, UMatrixStack uMatrixStack, Color color, double d, double d2, double d3, double d4, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawImage");
        }
        if ((n3 & 0x40) != 0) {
            n = 9728;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 9728;
        }
        imageComponent.drawImage(uMatrixStack, color, d, d2, d3, d4, n, n2);
    }

    @JvmOverloads
    public ImageComponent(@NotNull State<ResourceLocation> pathState, @NotNull UIImage.TextureScalingMode texMinFilter) {
        Intrinsics.checkNotNullParameter(pathState, (String)"pathState");
        Intrinsics.checkNotNullParameter((Object)((Object)texMinFilter), (String)"texMinFilter");
        this(pathState, texMinFilter, null, 4, null);
    }

    @JvmOverloads
    public ImageComponent(@NotNull State<ResourceLocation> pathState) {
        Intrinsics.checkNotNullParameter(pathState, (String)"pathState");
        this(pathState, null, null, 6, null);
    }

    @JvmOverloads
    public ImageComponent(@NotNull ResourceLocation path, @NotNull UIImage.TextureScalingMode texMinFilter) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)texMinFilter), (String)"texMinFilter");
        this(path, texMinFilter, null, 4, null);
    }

    @JvmOverloads
    public ImageComponent(@NotNull ResourceLocation path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, null, null, 6, null);
    }
}

