/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components.image;

import gg.essential.elementa.UIComponent;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J@\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0088\u0001\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a8\u0006\u001f"}, d2={"Lgg/essential/elementa/components/image/PlayerHeadComponent;", "Lgg/essential/elementa/UIComponent;", "()V", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawHead", "player", "Lnet/minecraft/world/entity/player/Player;", "x", "", "y", "width", "height", "color", "Ljava/awt/Color;", "drawScaledRect", "worldRenderer", "Lgg/essential/universal/UGraphics;", "stU", "stV", "endU", "endV", "texW", "texH", "red", "", "green", "blue", "alpha", "MSCore"})
public final class PlayerHeadComponent
extends UIComponent {
    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            super.draw(matrixStack);
            return;
        }
        LocalPlayer localPlayer = UMinecraft.getPlayer();
        if (localPlayer == null) {
            super.draw(matrixStack);
            return;
        }
        LocalPlayer player = localPlayer;
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getWidth();
        double height = this.getHeight();
        this.drawHead(matrixStack, (Player)player, x, y, width, height, color);
        super.draw(matrixStack);
    }

    private final void drawHead(UMatrixStack matrixStack, Player player, double x, double y, double width, double height, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        matrixStack.push();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.client.player.AbstractClientPlayer");
        UGraphics.bindTexture(0, ((AbstractClientPlayer)player).m_108560_());
        worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        Intrinsics.checkNotNull((Object)worldRenderer);
        this.drawScaledRect(matrixStack, worldRenderer, x, y, 8.0, 8.0, 8.0, 8.0, width, height, 64.0, 64.0, red, green, blue, alpha);
        this.drawScaledRect(matrixStack, worldRenderer, x, y, 40.0, 8.0, 8.0, 8.0, width, height, 64.0, 64.0, red, green, blue, alpha);
        worldRenderer.drawDirect();
        matrixStack.pop();
    }

    private final void drawScaledRect(UMatrixStack matrixStack, UGraphics worldRenderer, double x, double y, double stU, double stV, double endU, double endV, double width, double height, double texW, double texH, float red, float green, float blue, float alpha) {
        double aspectW = 1.0 / texW;
        double aspectH = 1.0 / texH;
        worldRenderer.pos(matrixStack, x, y + height, 0.0).tex(stU * aspectW, (stV + (double)((float)endV)) * aspectH).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y + height, 0.0).tex((stU + (double)((float)endU)) * aspectW, (stV + (double)((float)endV)) * aspectH).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x + width, y, 0.0).tex((stU + (double)((float)endU)) * aspectW, stV * aspectH).color(red, green, blue, alpha).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(stU * aspectW, stV * aspectH).color(red, green, blue, alpha).endVertex();
    }
}

