/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.constraints.animation;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.animation.AnimationComponent;
import gg.essential.elementa.constraints.animation.AnimationStrategy;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\"\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lgg/essential/elementa/constraints/animation/ColorAnimationComponent;", "Lgg/essential/elementa/constraints/animation/AnimationComponent;", "Ljava/awt/Color;", "Lgg/essential/elementa/constraints/ColorConstraint;", "strategy", "Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "totalFrames", "", "oldConstraint", "newConstraint", "delay", "(Lgg/essential/elementa/constraints/animation/AnimationStrategy;ILgg/essential/elementa/constraints/ColorConstraint;Lgg/essential/elementa/constraints/ColorConstraint;I)V", "cachedValue", "kotlin.jvm.PlatformType", "getCachedValue", "()Ljava/awt/Color;", "setCachedValue", "(Ljava/awt/Color;)V", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "getNewConstraint", "()Lgg/essential/elementa/constraints/ColorConstraint;", "getOldConstraint", "recalculate", "", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "animationFrame", "", "getColorImpl", "component", "to", "visitImpl", "visitor", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "type", "Lgg/essential/elementa/constraints/ConstraintType;", "MSCore"})
public final class ColorAnimationComponent
extends AnimationComponent<Color>
implements ColorConstraint {
    @NotNull
    private final ColorConstraint oldConstraint;
    @NotNull
    private final ColorConstraint newConstraint;
    private Color cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;

    public ColorAnimationComponent(@NotNull AnimationStrategy strategy, int totalFrames, @NotNull ColorConstraint oldConstraint, @NotNull ColorConstraint newConstraint, int delay2) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)oldConstraint, (String)"oldConstraint");
        Intrinsics.checkNotNullParameter((Object)newConstraint, (String)"newConstraint");
        super(strategy, totalFrames, delay2, null);
        this.oldConstraint = oldConstraint;
        this.newConstraint = newConstraint;
        this.cachedValue = Color.WHITE;
        this.recalculate = true;
    }

    @NotNull
    public final ColorConstraint getOldConstraint() {
        return this.oldConstraint;
    }

    @NotNull
    public final ColorConstraint getNewConstraint() {
        return this.newConstraint;
    }

    @Override
    public Color getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Color color) {
        this.cachedValue = color;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    @NotNull
    public Color getColorImpl(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Color startColor = this.oldConstraint.getColor(component2);
        Color endColor = this.newConstraint.getColor(component2);
        float percentComplete = this.getPercentComplete();
        float newR = (float)startColor.getRed() + (float)(endColor.getRed() - startColor.getRed()) * percentComplete;
        float newG = (float)startColor.getGreen() + (float)(endColor.getGreen() - startColor.getGreen()) * percentComplete;
        float newB = (float)startColor.getBlue() + (float)(endColor.getBlue() - startColor.getBlue()) * percentComplete;
        float newA = (float)startColor.getAlpha() + (float)(endColor.getAlpha() - startColor.getAlpha()) * percentComplete;
        return new Color(MathKt.roundToInt((float)newR), MathKt.roundToInt((float)newG), MathKt.roundToInt((float)newB), MathKt.roundToInt((float)newA));
    }

    @Override
    public void animationFrame() {
        super.animationFrame();
        this.oldConstraint.animationFrame();
        this.newConstraint.animationFrame();
    }

    @NotNull
    public ColorAnimationComponent to(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        ColorAnimationComponent $this$to_u24lambda_u240 = this;
        boolean bl = false;
        throw new UnsupportedOperationException("Constraint.to(UIComponent) is not available in this context!");
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.oldConstraint.visit(visitor, type, false);
        this.newConstraint.visit(visitor, type, false);
    }

    @Override
    @NotNull
    public Color getColor(@NotNull UIComponent component2) {
        return ColorConstraint.DefaultImpls.getColor(this, component2);
    }
}

