/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.constraints.resolution;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintResolverKt;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.constraints.resolution.DirectedAcyclicGraph;
import gg.essential.elementa.constraints.resolution.ResolverNode;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgg/essential/elementa/constraints/resolution/ConstraintResolver;", "", "window", "Lgg/essential/elementa/components/Window;", "(Lgg/essential/elementa/components/Window;)V", "graph", "Lgg/essential/elementa/constraints/resolution/DirectedAcyclicGraph;", "Lgg/essential/elementa/constraints/resolution/ResolverNode;", "getCyclicNodes", "", "MSCore"})
public final class ConstraintResolver {
    @NotNull
    private final DirectedAcyclicGraph<ResolverNode> graph;

    public ConstraintResolver(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.graph = new DirectedAcyclicGraph();
        ConstraintResolverKt.forEachChild(window, (Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResolverNode[] resolverNodeArray = new ResolverNode[]{new ResolverNode(it, it.getConstraints().getX(), ConstraintType.X), new ResolverNode(it, it.getConstraints().getY(), ConstraintType.Y), new ResolverNode(it, it.getConstraints().getWidth(), ConstraintType.WIDTH), new ResolverNode(it, it.getConstraints().getHeight(), ConstraintType.HEIGHT), new ResolverNode(it, it.getConstraints().getTextScale(), ConstraintType.TEXT_SCALE), new ResolverNode(it, it.getConstraints().getRadius(), ConstraintType.RADIUS)};
                graph.addVertices(resolverNodeArray);
            }
        }));
        ConstraintResolverKt.forEachChild(window, (Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ConstraintVisitor visitor = new ConstraintVisitor(graph, it);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getX(), visitor, ConstraintType.X, false, 4, null);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getY(), visitor, ConstraintType.Y, false, 4, null);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getWidth(), visitor, ConstraintType.WIDTH, false, 4, null);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getHeight(), visitor, ConstraintType.HEIGHT, false, 4, null);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getTextScale(), visitor, ConstraintType.TEXT_SCALE, false, 4, null);
                SuperConstraint.DefaultImpls.visit$default(it.getConstraints().getRadius(), visitor, ConstraintType.RADIUS, false, 4, null);
            }
        }));
    }

    @Nullable
    public final List<ResolverNode> getCyclicNodes() {
        return this.graph.getCyclicLoop();
    }
}

