/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.font;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.font.FontProvider;
import gg.essential.elementa.font.data.Atlas;
import gg.essential.elementa.font.data.AtlasBounds;
import gg.essential.elementa.font.data.Font;
import gg.essential.elementa.font.data.Glyph;
import gg.essential.elementa.font.data.Metrics;
import gg.essential.elementa.font.data.PlaneBounds;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.Float2Uniform;
import gg.essential.universal.shader.Float4Uniform;
import gg.essential.universal.shader.FloatUniform;
import gg.essential.universal.shader.SamplerUniform;
import gg.essential.universal.shader.UShader;
import java.awt.Color;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J@\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0002JR\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J8\u00103\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u00100\u001a\u00020)H\u0002J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u00020)H\u0016J\u000e\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\b\u00108\u001a\u00020)H\u0016J\u0018\u00109\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u00020)H\u0016J$\u0010:\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)0;2\u0006\u0010<\u001a\u00020/2\u0006\u00107\u001a\u00020)H\u0002J\u0018\u0010=\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u00020)H\u0016J\u0010\u0010>\u001a\u00020\"2\u0006\u00107\u001a\u00020)H\u0002J\u0010\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020EH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lgg/essential/elementa/font/FontRenderer;", "Lgg/essential/elementa/font/FontProvider;", "regularFont", "Lgg/essential/elementa/font/data/Font;", "boldFont", "(Lgg/essential/elementa/font/data/Font;Lgg/essential/elementa/font/data/Font;)V", "activeFont", "bold", "", "cachedValue", "getCachedValue", "()Lgg/essential/elementa/font/FontProvider;", "setCachedValue", "(Lgg/essential/elementa/font/FontProvider;)V", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "drawingShadow", "italics", "obfuscated", "recalculate", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "shadowColor", "Ljava/awt/Color;", "strikethrough", "textColor", "underline", "drawGlyph", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "glyph", "Lgg/essential/elementa/font/data/Glyph;", "color", "x", "", "y", "width", "height", "drawString", "string", "", "originalPointSize", "scale", "shadow", "drawStringNow", "getBaseLineHeight", "getBelowLineHeight", "getLineHeight", "pointSize", "getShadowHeight", "getStringHeight", "getStringInformation", "Lkotlin/Pair;", "text", "getStringWidth", "refreshColor", "switchFont", "type", "", "visitImpl", "visitor", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "Lgg/essential/elementa/constraints/ConstraintType;", "Companion", "MSCore"})
public final class FontRenderer
implements FontProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Font regularFont;
    @NotNull
    private final Font boldFont;
    private boolean underline;
    private boolean strikethrough;
    private boolean bold;
    private boolean italics;
    private boolean obfuscated;
    @Nullable
    private Color textColor;
    @Nullable
    private Color shadowColor;
    private boolean drawingShadow;
    @NotNull
    private Font activeFont;
    @NotNull
    private FontProvider cachedValue;
    private boolean recalculate;
    @Nullable
    private UIComponent constrainTo;
    @NotNull
    private static final Regex hexRegex = new Regex("#([0-9A-Fa-f]{6})([^#]*)");
    @NotNull
    private static final Map<Integer, Color> colors;
    public static UShader shader;
    public static SamplerUniform samplerUniform;
    public static FloatUniform doffsetUniform;
    public static FloatUniform hintAmountUniform;
    public static FloatUniform subpixelAmountUniform;
    public static Float2Uniform sdfTexel;
    public static Float4Uniform fgColorUniform;

    public FontRenderer(@NotNull Font regularFont, @NotNull Font boldFont) {
        Intrinsics.checkNotNullParameter((Object)regularFont, (String)"regularFont");
        Intrinsics.checkNotNullParameter((Object)boldFont, (String)"boldFont");
        this.regularFont = regularFont;
        this.boldFont = boldFont;
        this.activeFont = this.regularFont;
        this.cachedValue = this;
    }

    public /* synthetic */ FontRenderer(Font font, Font font2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            font2 = font;
        }
        this(font, font2);
    }

    @Override
    @NotNull
    public FontProvider getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(@NotNull FontProvider fontProvider) {
        Intrinsics.checkNotNullParameter((Object)fontProvider, (String)"<set-?>");
        this.cachedValue = fontProvider;
    }

    @Override
    public boolean getRecalculate() {
        return this.recalculate;
    }

    @Override
    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @Override
    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    @Override
    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    @Override
    public float getStringWidth(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringInformation(string, pointSize).getFirst()).floatValue();
    }

    @Override
    public float getStringHeight(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return ((Number)this.getStringInformation(string, pointSize).getSecond()).floatValue();
    }

    private final Pair<Float, Float> getStringInformation(String text, float pointSize) {
        float width = 0.0f;
        float height = 0.0f;
        float currentPointSize = pointSize;
        int index = 0;
        float offsetX = 0.0f;
        while (index < text.length()) {
            Glyph glyph;
            char c = text.charAt(index);
            if ((c == '\u00a7' || c == '&') && index + 1 < text.length()) {
                int codeFormat = StringsKt.indexOf$default((CharSequence)"0123456789abcdefklmnor", (char)text.charAt(index + 1), (int)0, (boolean)false, (int)6, null);
                if (codeFormat == 17) {
                    this.activeFont = this.boldFont;
                    offsetX = 0.0f;
                } else {
                    currentPointSize = pointSize;
                    this.activeFont = this.regularFont;
                    offsetX = 0.0f;
                }
                if (codeFormat == 20) {
                    offsetX = 0.2f;
                }
                index += 2;
                continue;
            }
            if (c == '#') {
                Character next;
                Character c2 = next = StringsKt.getOrNull((CharSequence)text, (int)(index + 1));
                char c3 = 'r';
                if (c2 != null && c2.charValue() == c3) {
                    index += 2;
                    continue;
                }
                if (index + 7 < text.length()) {
                    String hexColor;
                    Intrinsics.checkNotNullExpressionValue((Object)text.substring(index, index + 7), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (hexRegex.matches((CharSequence)hexColor)) {
                        index += 7;
                        continue;
                    }
                }
            }
            if ((glyph = this.activeFont.getFontInfo().getGlyphs().get(c)) == null) {
                ++index;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                float heightPointSize = currentPointSize * 1.1f;
                height = Math.max((planeBounds.getTop() - planeBounds.getBottom()) * heightPointSize, height);
            }
            width += glyph.getAdvance() * currentPointSize + offsetX;
            ++index;
        }
        return new Pair((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    public final float getLineHeight(float pointSize) {
        return this.activeFont.getFontInfo().getMetrics().getLineHeight() * pointSize;
    }

    private final void switchFont(int type) {
        Font tmp = this.activeFont;
        switch (type) {
            case 1: {
                this.activeFont = this.regularFont;
                break;
            }
            case 2: {
                this.activeFont = this.boldFont;
            }
        }
        Companion.getSamplerUniform$MSCore().setValue(this.activeFont.getTexture().getDynamicGlId());
        if (!Intrinsics.areEqual((Object)this.activeFont, (Object)tmp)) {
            UGraphics.configureTexture(this.activeFont.getTexture().getDynamicGlId(), FontRenderer::switchFont$lambda$0);
            Companion.getSdfTexel$MSCore().setValue(1.0f / this.activeFont.getFontInfo().getAtlas().getWidth(), 1.0f / this.activeFont.getFontInfo().getAtlas().getHeight());
        }
    }

    @Override
    public void drawString(@NotNull UMatrixStack matrixStack, @NotNull String string, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float effectiveSize = scale;
        float adjustedY = y - effectiveSize / 3.5f;
        if (shadow) {
            this.drawingShadow = true;
            Color effectiveShadow = shadowColor;
            int baseColor = color.getRGB();
            if (effectiveShadow == null) {
                if ((baseColor & 0xFC000000) == 0) {
                    baseColor |= 0xFF000000;
                }
                baseColor = (baseColor & 0xFCFCFC) >> 2 | baseColor & 0xFF000000;
            }
            this.shadowColor = new Color(baseColor);
            float shadowOffset = effectiveSize / (float)10;
            matrixStack.translate(shadowOffset, shadowOffset, 0.0f);
            this.drawStringNow(matrixStack, string, new Color(baseColor), x, adjustedY, effectiveSize);
            matrixStack.translate(-shadowOffset, -shadowOffset, 0.0f);
        }
        this.drawingShadow = false;
        this.drawStringNow(matrixStack, string, color, x, adjustedY, effectiveSize);
    }

    @Override
    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    @Override
    public float getBaseLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBaseCharHeight();
    }

    @Override
    public float getShadowHeight() {
        return this.regularFont.getFontInfo().getAtlas().getShadowHeight();
    }

    @Override
    public float getBelowLineHeight() {
        return this.regularFont.getFontInfo().getAtlas().getBelowLineHeight();
    }

    private final void refreshColor(float pointSize) {
        Color current;
        Color color = current = this.drawingShadow ? this.shadowColor : this.textColor;
        Intrinsics.checkNotNull((Object)color);
        float amt = Color.RGBtoHSB(color.getRed(), current.getGreen(), current.getBlue(), null)[2];
        Companion.getHintAmountUniform$MSCore().setValue(0.0f);
    }

    private final void drawStringNow(UMatrixStack matrixStack, String string, Color color, float x, float y, float originalPointSize) {
        if (!Companion.areShadersInitialized() || !Companion.getShader$MSCore().getUsable()) {
            return;
        }
        float currentPointSize = originalPointSize;
        Companion.getShader$MSCore().bind();
        this.switchFont(1);
        Companion.getDoffsetUniform$MSCore().setValue(4.0f / currentPointSize);
        this.obfuscated = false;
        this.bold = false;
        this.italics = false;
        this.strikethrough = false;
        this.underline = false;
        this.textColor = color;
        this.refreshColor(originalPointSize);
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        float currentX = 0.0f;
        float currentY = 0.0f;
        int index = 0;
        while (index < string.length()) {
            Glyph glyph;
            char c = string.charAt(index);
            if ((c == '\u00a7' || c == '&') && index + 1 < string.length()) {
                int codeFormat = StringsKt.indexOf$default((CharSequence)"0123456789abcdefklmnor", (char)string.charAt(index + 1), (int)0, (boolean)false, (int)6, null);
                if (codeFormat < 16) {
                    this.obfuscated = false;
                    this.bold = false;
                    this.italics = false;
                    this.strikethrough = false;
                    this.underline = false;
                    if (codeFormat < 0) {
                        this.textColor = colors.get(15);
                        this.shadowColor = colors.get(31);
                    } else {
                        this.textColor = colors.get(codeFormat);
                        this.shadowColor = colors.get(codeFormat + 16);
                    }
                    currentPointSize = originalPointSize;
                    Companion.getDoffsetUniform$MSCore().setValue(3.5f / currentPointSize);
                    this.refreshColor(originalPointSize);
                } else if (codeFormat == 16) {
                    this.obfuscated = true;
                } else if (codeFormat == 17) {
                    this.switchFont(2);
                    Companion.getDoffsetUniform$MSCore().setValue(4.0f / currentPointSize);
                    this.bold = true;
                } else if (codeFormat == 18) {
                    this.strikethrough = true;
                } else if (codeFormat == 19) {
                    this.underline = true;
                } else if (codeFormat == 20) {
                    this.italics = true;
                } else {
                    currentPointSize = originalPointSize;
                    this.switchFont(1);
                    Companion.getDoffsetUniform$MSCore().setValue(3.5f / currentPointSize);
                    this.obfuscated = false;
                    this.bold = false;
                    this.italics = false;
                    this.strikethrough = false;
                    this.underline = false;
                    this.textColor = color;
                    this.refreshColor(originalPointSize);
                }
                index += 2;
                continue;
            }
            if (c == '#') {
                Character next;
                Character c2 = next = StringsKt.getOrNull((CharSequence)string, (int)(index + 1));
                char c3 = 'r';
                if (c2 != null && c2.charValue() == c3) {
                    this.textColor = color;
                    index += 2;
                    continue;
                }
                if (index + 7 < string.length()) {
                    String hexColor;
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(index, index + 7), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (hexRegex.matches((CharSequence)hexColor)) {
                        String string2 = hexColor.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                        this.textColor = new Color(Integer.parseInt(string2, CharsKt.checkRadix((int)16)));
                        index += 7;
                        continue;
                    }
                }
            }
            if ((glyph = this.activeFont.getFontInfo().getGlyphs().get(c)) == null) {
                ++index;
                continue;
            }
            if (this.obfuscated && c != ' ') {
                float advance = glyph.getAdvance();
                for (int iter = 1; iter < 101; ++iter) {
                    char tmp = StringsKt.random((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", (Random)((Random)Random.Default));
                    Glyph glyph2 = this.activeFont.getFontInfo().getGlyphs().get(tmp);
                    if (glyph2 == null) {
                        continue;
                    }
                    if (!(advance == glyph2.getAdvance())) continue;
                    glyph = this.activeFont.getFontInfo().getGlyphs().get(tmp);
                    break;
                }
            }
            if (glyph == null) {
                ++index;
                continue;
            }
            PlaneBounds planeBounds = glyph.getPlaneBounds();
            if (planeBounds != null) {
                Metrics metrics = this.activeFont.getFontInfo().getMetrics();
                float baseline = (metrics.getLineHeight() + metrics.getDescender()) * currentPointSize;
                float width = (planeBounds.getRight() - planeBounds.getLeft()) * currentPointSize;
                float height = (planeBounds.getTop() - planeBounds.getBottom()) * currentPointSize;
                currentY = Math.max(height, currentY);
                float hintedY = baseline - planeBounds.getTop() * currentPointSize;
                Color color2 = this.textColor;
                Intrinsics.checkNotNull((Object)color2);
                this.drawGlyph(matrixStack, glyph, color2, x + currentX, y + hintedY, width, height);
            }
            currentX += glyph.getAdvance() * currentPointSize;
            ++index;
        }
        Companion.getShader$MSCore().unbind();
        if (this.underline) {
            RenderSystem.lineWidth((float)1.0f);
            double w = currentX;
            double h = currentY;
            worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.LINES, UGraphics.CommonVertexFormats.POSITION_COLOR_NORMAL);
            worldRenderer.pos(matrixStack, (double)x + 2.0, (double)y + h + 8.0, 0.0).color(color).norm(matrixStack, 1.0f, 0.0f, 0.0f).endVertex();
            worldRenderer.pos(matrixStack, (double)x + w + 4.0, (double)y + h + 8.0, 0.0).color(color).norm(matrixStack, 1.0f, 0.0f, 0.0f).endVertex();
            worldRenderer.drawDirect();
        }
        if (this.strikethrough) {
            RenderSystem.lineWidth((float)1.0f);
            double w = currentX;
            double h = currentY;
            worldRenderer.beginWithDefaultShader(UGraphics.DrawMode.LINES, UGraphics.CommonVertexFormats.POSITION_COLOR_NORMAL);
            worldRenderer.pos(matrixStack, (double)x + 2.0, (double)y + h, 0.0).color(color).norm(1.0f, 0.0f, 0.0f).endVertex();
            worldRenderer.pos(matrixStack, (double)x + w + 4.0, (double)y + h, 0.0).color(color).norm(1.0f, 0.0f, 0.0f).endVertex();
            worldRenderer.drawDirect();
        }
        this.activeFont = this.boldFont;
    }

    private final void drawGlyph(UMatrixStack matrixStack, Glyph glyph, Color color, float x, float y, float width, float height) {
        Color color2;
        AtlasBounds atlasBounds = glyph.getAtlasBounds();
        if (atlasBounds == null) {
            return;
        }
        AtlasBounds atlasBounds2 = atlasBounds;
        Atlas atlas = this.activeFont.getFontInfo().getAtlas();
        double textureTop = 1.0 - (double)(atlasBounds2.getTop() / atlas.getHeight());
        double textureBottom = 1.0 - (double)(atlasBounds2.getBottom() / atlas.getHeight());
        double textureLeft = atlasBounds2.getLeft() / atlas.getWidth();
        double textureRight = atlasBounds2.getRight() / atlas.getWidth();
        if (this.drawingShadow) {
            color2 = this.shadowColor;
            if (color2 == null) {
                color2 = color;
            }
        } else {
            color2 = this.textColor;
            if (color2 == null) {
                color2 = color;
            }
        }
        Color drawColor = color2;
        Companion.getFgColorUniform$MSCore().setValue((float)drawColor.getRed() / 255.0f, (float)drawColor.getGreen() / 255.0f, (float)drawColor.getBlue() / 255.0f, (float)drawColor.getAlpha() / 255.0f);
        UGraphics worldRenderer = UGraphics.getFromTessellator();
        double doubleX = x;
        double doubleY = y;
        double italicOffset = this.italics ? 1.0 : 0.0;
        worldRenderer.beginWithActiveShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
        worldRenderer.pos(matrixStack, doubleX - italicOffset, doubleY + (double)height, 0.0).tex(textureLeft, textureBottom).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width - italicOffset, doubleY + (double)height, 0.0).tex(textureRight, textureBottom).endVertex();
        worldRenderer.pos(matrixStack, doubleX + (double)width + italicOffset, doubleY, 0.0).tex(textureRight, textureTop).endVertex();
        worldRenderer.pos(matrixStack, doubleX + italicOffset, doubleY, 0.0).tex(textureLeft, textureTop).endVertex();
        worldRenderer.drawDirect();
    }

    @Override
    @Deprecated(message="For 1.17 this method requires you pass a UMatrixStack as the first argument.\n\nIf you are currently extending this method, you should instead extend the method with the added argument.\nNote however for this to be non-breaking, your parent class needs to transition before you do.\n\nIf you are calling this method and you cannot guarantee that your target class has been fully updated (such as when\ncalling an open method on an open class), you should instead call the method with the \"Compat\" suffix, which will\ncall both methods, the new and the deprecated one.\nIf you are sure that your target class has been updated (such as when calling the super method), you should\n(for super calls you must!) instead just call the method with the original name and added argument.", replaceWith=@ReplaceWith(expression="drawString(matrixStack, string, color, x, y, originalPointSize, scale, shadow, shadowColor)", imports={}))
    public void drawString(@NotNull String string, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        FontProvider.DefaultImpls.drawString(this, string, color, x, y, originalPointSize, scale, shadow, shadowColor);
    }

    @Override
    public void animationFrame() {
        FontProvider.DefaultImpls.animationFrame(this);
    }

    @Override
    @NotNull
    public SuperConstraint<FontProvider> to(@NotNull UIComponent component2) {
        return FontProvider.DefaultImpls.to(this, component2);
    }

    @Override
    public void pauseIfSupported() {
        FontProvider.DefaultImpls.pauseIfSupported(this);
    }

    @Override
    public void resumeIfSupported() {
        FontProvider.DefaultImpls.resumeIfSupported(this);
    }

    @Override
    public void stopIfSupported() {
        FontProvider.DefaultImpls.stopIfSupported(this);
    }

    @Override
    public void visit(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type, boolean setNewConstraint) {
        FontProvider.DefaultImpls.visit(this, visitor, type, setNewConstraint);
    }

    private static final void switchFont$lambda$0() {
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)Color.BLACK), TuplesKt.to((Object)1, (Object)new Color(0, 0, 170)), TuplesKt.to((Object)2, (Object)new Color(0, 170, 0)), TuplesKt.to((Object)3, (Object)new Color(0, 170, 170)), TuplesKt.to((Object)4, (Object)new Color(170, 0, 0)), TuplesKt.to((Object)5, (Object)new Color(170, 0, 170)), TuplesKt.to((Object)6, (Object)new Color(255, 170, 0)), TuplesKt.to((Object)7, (Object)new Color(170, 170, 170)), TuplesKt.to((Object)8, (Object)new Color(85, 85, 85)), TuplesKt.to((Object)9, (Object)new Color(85, 85, 255)), TuplesKt.to((Object)10, (Object)new Color(85, 255, 85)), TuplesKt.to((Object)11, (Object)new Color(85, 255, 255)), TuplesKt.to((Object)12, (Object)new Color(255, 85, 85)), TuplesKt.to((Object)13, (Object)new Color(255, 85, 255)), TuplesKt.to((Object)14, (Object)new Color(255, 255, 85)), TuplesKt.to((Object)15, (Object)new Color(255, 255, 255)), TuplesKt.to((Object)16, (Object)Color.BLACK), TuplesKt.to((Object)17, (Object)new Color(0, 0, 42)), TuplesKt.to((Object)18, (Object)new Color(0, 42, 0)), TuplesKt.to((Object)19, (Object)new Color(0, 42, 42)), TuplesKt.to((Object)20, (Object)new Color(42, 0, 0)), TuplesKt.to((Object)21, (Object)new Color(42, 0, 42)), TuplesKt.to((Object)22, (Object)new Color(42, 42, 0)), TuplesKt.to((Object)23, (Object)new Color(42, 42, 42)), TuplesKt.to((Object)24, (Object)new Color(21, 21, 21)), TuplesKt.to((Object)25, (Object)new Color(21, 21, 63)), TuplesKt.to((Object)26, (Object)new Color(21, 63, 21)), TuplesKt.to((Object)27, (Object)new Color(21, 63, 63)), TuplesKt.to((Object)28, (Object)new Color(63, 21, 21)), TuplesKt.to((Object)29, (Object)new Color(63, 21, 63)), TuplesKt.to((Object)30, (Object)new Color(63, 63, 21)), TuplesKt.to((Object)31, (Object)new Color(63, 63, 63))};
        colors = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\fR\u001a\u0010\u0018\u001a\u00020\u0019X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\f\u00a8\u00061"}, d2={"Lgg/essential/elementa/font/FontRenderer$Companion;", "", "()V", "colors", "", "", "Ljava/awt/Color;", "doffsetUniform", "Lgg/essential/universal/shader/FloatUniform;", "getDoffsetUniform$MSCore", "()Lgg/essential/universal/shader/FloatUniform;", "setDoffsetUniform$MSCore", "(Lgg/essential/universal/shader/FloatUniform;)V", "fgColorUniform", "Lgg/essential/universal/shader/Float4Uniform;", "getFgColorUniform$MSCore", "()Lgg/essential/universal/shader/Float4Uniform;", "setFgColorUniform$MSCore", "(Lgg/essential/universal/shader/Float4Uniform;)V", "hexRegex", "Lkotlin/text/Regex;", "hintAmountUniform", "getHintAmountUniform$MSCore", "setHintAmountUniform$MSCore", "samplerUniform", "Lgg/essential/universal/shader/SamplerUniform;", "getSamplerUniform$MSCore", "()Lgg/essential/universal/shader/SamplerUniform;", "setSamplerUniform$MSCore", "(Lgg/essential/universal/shader/SamplerUniform;)V", "sdfTexel", "Lgg/essential/universal/shader/Float2Uniform;", "getSdfTexel$MSCore", "()Lgg/essential/universal/shader/Float2Uniform;", "setSdfTexel$MSCore", "(Lgg/essential/universal/shader/Float2Uniform;)V", "shader", "Lgg/essential/universal/shader/UShader;", "getShader$MSCore", "()Lgg/essential/universal/shader/UShader;", "setShader$MSCore", "(Lgg/essential/universal/shader/UShader;)V", "subpixelAmountUniform", "getSubpixelAmountUniform$MSCore", "setSubpixelAmountUniform$MSCore", "areShadersInitialized", "", "initShaders", "", "MSCore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UShader getShader$MSCore() {
            UShader uShader = shader;
            if (uShader != null) {
                return uShader;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            return null;
        }

        public final void setShader$MSCore(@NotNull UShader uShader) {
            Intrinsics.checkNotNullParameter((Object)uShader, (String)"<set-?>");
            shader = uShader;
        }

        @NotNull
        public final SamplerUniform getSamplerUniform$MSCore() {
            SamplerUniform samplerUniform = FontRenderer.samplerUniform;
            if (samplerUniform != null) {
                return samplerUniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"samplerUniform");
            return null;
        }

        public final void setSamplerUniform$MSCore(@NotNull SamplerUniform samplerUniform) {
            Intrinsics.checkNotNullParameter((Object)samplerUniform, (String)"<set-?>");
            FontRenderer.samplerUniform = samplerUniform;
        }

        @NotNull
        public final FloatUniform getDoffsetUniform$MSCore() {
            FloatUniform floatUniform = doffsetUniform;
            if (floatUniform != null) {
                return floatUniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"doffsetUniform");
            return null;
        }

        public final void setDoffsetUniform$MSCore(@NotNull FloatUniform floatUniform) {
            Intrinsics.checkNotNullParameter((Object)floatUniform, (String)"<set-?>");
            doffsetUniform = floatUniform;
        }

        @NotNull
        public final FloatUniform getHintAmountUniform$MSCore() {
            FloatUniform floatUniform = hintAmountUniform;
            if (floatUniform != null) {
                return floatUniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"hintAmountUniform");
            return null;
        }

        public final void setHintAmountUniform$MSCore(@NotNull FloatUniform floatUniform) {
            Intrinsics.checkNotNullParameter((Object)floatUniform, (String)"<set-?>");
            hintAmountUniform = floatUniform;
        }

        @NotNull
        public final FloatUniform getSubpixelAmountUniform$MSCore() {
            FloatUniform floatUniform = subpixelAmountUniform;
            if (floatUniform != null) {
                return floatUniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subpixelAmountUniform");
            return null;
        }

        public final void setSubpixelAmountUniform$MSCore(@NotNull FloatUniform floatUniform) {
            Intrinsics.checkNotNullParameter((Object)floatUniform, (String)"<set-?>");
            subpixelAmountUniform = floatUniform;
        }

        @NotNull
        public final Float2Uniform getSdfTexel$MSCore() {
            Float2Uniform float2Uniform = sdfTexel;
            if (float2Uniform != null) {
                return float2Uniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdfTexel");
            return null;
        }

        public final void setSdfTexel$MSCore(@NotNull Float2Uniform float2Uniform) {
            Intrinsics.checkNotNullParameter((Object)float2Uniform, (String)"<set-?>");
            sdfTexel = float2Uniform;
        }

        @NotNull
        public final Float4Uniform getFgColorUniform$MSCore() {
            Float4Uniform float4Uniform = fgColorUniform;
            if (float4Uniform != null) {
                return float4Uniform;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"fgColorUniform");
            return null;
        }

        public final void setFgColorUniform$MSCore(@NotNull Float4Uniform float4Uniform) {
            Intrinsics.checkNotNullParameter((Object)float4Uniform, (String)"<set-?>");
            fgColorUniform = float4Uniform;
        }

        public final boolean areShadersInitialized() {
            return shader != null;
        }

        public final void initShaders() {
            if (this.areShadersInitialized()) {
                return;
            }
            this.setShader$MSCore(ExtensionsKt.readFromLegacyShader(UShader.Companion, "font", "font", BlendState.NORMAL));
            if (!this.getShader$MSCore().getUsable()) {
                System.out.println((Object)"Failed to load Elementa font shader");
                return;
            }
            this.setSamplerUniform$MSCore(this.getShader$MSCore().getSamplerUniform("msdf"));
            this.setDoffsetUniform$MSCore(this.getShader$MSCore().getFloatUniform("doffset"));
            this.setHintAmountUniform$MSCore(this.getShader$MSCore().getFloatUniform("hint_amount"));
            this.setSdfTexel$MSCore(this.getShader$MSCore().getFloat2Uniform("sdf_texel"));
            this.setFgColorUniform$MSCore(this.getShader$MSCore().getFloat4Uniform("fgColor"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

