/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.selection;

import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.drawables.TextDrawable;
import gg.essential.elementa.markdown.selection.Cursor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000f\u001a\u00020\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0011"}, d2={"Lgg/essential/elementa/markdown/selection/TextCursor;", "Lgg/essential/elementa/markdown/selection/Cursor;", "Lgg/essential/elementa/markdown/drawables/TextDrawable;", "target", "offset", "", "(Lgg/essential/elementa/markdown/drawables/TextDrawable;I)V", "getOffset", "()I", "xBase", "", "getXBase", "()F", "yBase", "getYBase", "compareTo", "other", "MSCore"})
public final class TextCursor
extends Cursor<TextDrawable> {
    private final int offset;
    private final float xBase;
    private final float yBase;

    public TextCursor(@NotNull TextDrawable target, int offset) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super((Drawable)target);
        this.offset = offset;
        float f = target.getX();
        String string = target.getFormattedText().substring(0, this.offset + target.getStyle().getNumFormattingChars());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.xBase = f + UtilitiesKt.width$default(string, target.getScaleModifier(), null, 2, null);
        this.yBase = target.getY();
    }

    public final int getOffset() {
        return this.offset;
    }

    @Override
    protected float getXBase() {
        return this.xBase;
    }

    @Override
    protected float getYBase() {
        return this.yBase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull Cursor<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (!(other instanceof TextCursor)) {
            void var2_2;
            int it = Float.compare(((TextDrawable)this.getTarget()).getY(), ((Drawable)other.getTarget()).getY());
            boolean bl = false;
            return it == 0 ? Float.compare(((TextDrawable)this.getTarget()).getX(), ((Drawable)other.getTarget()).getX()) : var2_2;
        }
        if (Intrinsics.areEqual(this.getTarget(), ((TextCursor)other).getTarget())) {
            return Intrinsics.compare((int)this.offset, (int)((TextCursor)other).offset);
        }
        if (((TextDrawable)this.getTarget()).getY() == ((TextDrawable)((TextCursor)other).getTarget()).getY()) {
            return Float.compare(((TextDrawable)this.getTarget()).getX(), ((TextDrawable)((TextCursor)other).getTarget()).getX());
        }
        return Float.compare(((TextDrawable)this.getTarget()).getY(), ((TextDrawable)((TextCursor)other).getTarget()).getY());
    }
}

