/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.universal.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import gg.essential.universal.UGraphics;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.DirectFloat2Uniform;
import gg.essential.universal.shader.DirectFloat3Uniform;
import gg.essential.universal.shader.DirectFloat4Uniform;
import gg.essential.universal.shader.DirectFloatMatrixUniform;
import gg.essential.universal.shader.DirectFloatUniform;
import gg.essential.universal.shader.DirectIntUniform;
import gg.essential.universal.shader.DirectSamplerUniform;
import gg.essential.universal.shader.Float2Uniform;
import gg.essential.universal.shader.Float3Uniform;
import gg.essential.universal.shader.Float4Uniform;
import gg.essential.universal.shader.FloatMatrixUniform;
import gg.essential.universal.shader.FloatUniform;
import gg.essential.universal.shader.GlShader;
import gg.essential.universal.shader.IntUniform;
import gg.essential.universal.shader.SamplerUniform;
import gg.essential.universal.shader.UShader;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 92\u00020\u0001:\u00019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u001d\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0017\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u001cH\u0016J\u001f\u00105\u001a\u00020\u001c2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001c07H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b8R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006:"}, d2={"Lgg/essential/universal/shader/GlShader;", "Lgg/essential/universal/shader/UShader;", "vertSource", "", "fragSource", "blendState", "Lgg/essential/universal/shader/BlendState;", "(Ljava/lang/String;Ljava/lang/String;Lgg/essential/universal/shader/BlendState;)V", "<set-?>", "", "bound", "getBound", "()Z", "fragShader", "", "prevActiveTexture", "prevBlendState", "prevTextureBindings", "", "program", "samplers", "Lgg/essential/universal/shader/DirectSamplerUniform;", "usable", "getUsable", "setUsable", "(Z)V", "vertShader", "bind", "", "createShader", "doBindTexture", "textureUnit", "textureId", "doBindTexture$MSCore", "getFloat2UniformOrNull", "Lgg/essential/universal/shader/DirectFloat2Uniform;", "name", "getFloat3UniformOrNull", "Lgg/essential/universal/shader/DirectFloat3Uniform;", "getFloat4UniformOrNull", "Lgg/essential/universal/shader/DirectFloat4Uniform;", "getFloatMatrixUniformOrNull", "Lgg/essential/universal/shader/DirectFloatMatrixUniform;", "getFloatUniformOrNull", "Lgg/essential/universal/shader/DirectFloatUniform;", "getIntUniformOrNull", "Lgg/essential/universal/shader/DirectIntUniform;", "getSamplerUniformOrNull", "Lgg/essential/universal/shader/SamplerUniform;", "getUniformLocation", "uniformName", "(Ljava/lang/String;)Ljava/lang/Integer;", "unbind", "withProgramBound", "block", "Lkotlin/Function0;", "withProgramBound$MSCore", "Companion", "MSCore"})
@SourceDebugExtension(value={"SMAP\nGlShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlShader.kt\ngg/essential/universal/shader/GlShader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class GlShader
implements UShader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String vertSource;
    @NotNull
    private final String fragSource;
    @NotNull
    private final BlendState blendState;
    private int program;
    private int vertShader;
    private int fragShader;
    @NotNull
    private Map<String, DirectSamplerUniform> samplers;
    private boolean usable;
    private boolean bound;
    private int prevActiveTexture;
    @NotNull
    private Map<Integer, Integer> prevTextureBindings;
    @Nullable
    private BlendState prevBlendState;
    private static final boolean CORE = UGraphics.isOpenGl21Supported();

    public GlShader(@NotNull String vertSource, @NotNull String fragSource, @NotNull BlendState blendState) {
        Intrinsics.checkNotNullParameter((Object)vertSource, (String)"vertSource");
        Intrinsics.checkNotNullParameter((Object)fragSource, (String)"fragSource");
        Intrinsics.checkNotNullParameter((Object)blendState, (String)"blendState");
        this.vertSource = vertSource;
        this.fragSource = fragSource;
        this.blendState = blendState;
        this.program = UGraphics.glCreateProgram();
        this.vertShader = UGraphics.glCreateShader(35633);
        this.fragShader = UGraphics.glCreateShader(35632);
        this.samplers = new LinkedHashMap();
        this.prevTextureBindings = new LinkedHashMap();
        this.createShader();
    }

    @Override
    public boolean getUsable() {
        return this.usable;
    }

    public void setUsable(boolean bl) {
        this.usable = bl;
    }

    public final boolean getBound() {
        return this.bound;
    }

    @Override
    public void bind() {
        this.prevActiveTexture = GL11.glGetInteger((int)34016);
        for (DirectSamplerUniform sampler : this.samplers.values()) {
            this.doBindTexture$MSCore(sampler.getTextureUnit(), sampler.getTextureId());
        }
        this.prevBlendState = BlendState.Companion.active();
        this.blendState.activate();
        UGraphics.glUseProgram(this.program);
        this.bound = true;
    }

    public final void doBindTexture$MSCore(int textureUnit, int textureId) {
        RenderSystem.activeTexture((int)(33984 + textureUnit));
        this.prevTextureBindings.computeIfAbsent(textureUnit, arg_0 -> GlShader.doBindTexture$lambda$0(doBindTexture.1.INSTANCE, arg_0));
        RenderSystem.bindTexture((int)textureId);
    }

    @Override
    public void unbind() {
        for (Map.Entry<Integer, Integer> entry : this.prevTextureBindings.entrySet()) {
            int textureUnit = ((Number)entry.getKey()).intValue();
            int textureId = ((Number)entry.getValue()).intValue();
            RenderSystem.activeTexture((int)(33984 + textureUnit));
            RenderSystem.bindTexture((int)textureId);
        }
        this.prevTextureBindings.clear();
        RenderSystem.activeTexture((int)this.prevActiveTexture);
        BlendState blendState = this.prevBlendState;
        if (blendState != null) {
            blendState.activate();
        }
        UGraphics.glUseProgram(0);
        this.bound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withProgramBound$MSCore(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withProgramBound$MSCore = false;
        if (this.getBound()) {
            block.invoke();
        } else {
            int prevProgram = GL11.glGetInteger((int)35725);
            try {
                UGraphics.glUseProgram(this.program);
                block.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                UGraphics.glUseProgram(prevProgram);
                InlineMarker.finallyEnd((int)1);
            }
        }
    }

    private final Integer getUniformLocation(String uniformName) {
        int loc = CORE ? GL20.glGetUniformLocation((int)this.program, (CharSequence)uniformName) : ARBShaderObjects.glGetUniformLocationARB((int)this.program, (CharSequence)uniformName);
        return loc == -1 ? null : Integer.valueOf(loc);
    }

    @Override
    @Nullable
    public DirectIntUniform getIntUniformOrNull(@NotNull String name) {
        DirectIntUniform directIntUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directIntUniform = new DirectIntUniform(p0);
        } else {
            directIntUniform = null;
        }
        return directIntUniform;
    }

    @Override
    @Nullable
    public DirectFloatUniform getFloatUniformOrNull(@NotNull String name) {
        DirectFloatUniform directFloatUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directFloatUniform = new DirectFloatUniform(p0);
        } else {
            directFloatUniform = null;
        }
        return directFloatUniform;
    }

    @Override
    @Nullable
    public DirectFloat2Uniform getFloat2UniformOrNull(@NotNull String name) {
        DirectFloat2Uniform directFloat2Uniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directFloat2Uniform = new DirectFloat2Uniform(p0);
        } else {
            directFloat2Uniform = null;
        }
        return directFloat2Uniform;
    }

    @Override
    @Nullable
    public DirectFloat3Uniform getFloat3UniformOrNull(@NotNull String name) {
        DirectFloat3Uniform directFloat3Uniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directFloat3Uniform = new DirectFloat3Uniform(p0);
        } else {
            directFloat3Uniform = null;
        }
        return directFloat3Uniform;
    }

    @Override
    @Nullable
    public DirectFloat4Uniform getFloat4UniformOrNull(@NotNull String name) {
        DirectFloat4Uniform directFloat4Uniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directFloat4Uniform = new DirectFloat4Uniform(p0);
        } else {
            directFloat4Uniform = null;
        }
        return directFloat4Uniform;
    }

    @Override
    @Nullable
    public DirectFloatMatrixUniform getFloatMatrixUniformOrNull(@NotNull String name) {
        DirectFloatMatrixUniform directFloatMatrixUniform;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getUniformLocation(name);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            directFloatMatrixUniform = new DirectFloatMatrixUniform(p0);
        } else {
            directFloatMatrixUniform = null;
        }
        return directFloatMatrixUniform;
    }

    @Override
    @Nullable
    public SamplerUniform getSamplerUniformOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DirectSamplerUniform directSamplerUniform = this.samplers.get(name);
        if (directSamplerUniform != null) {
            DirectSamplerUniform it = directSamplerUniform;
            boolean bl = false;
            return it;
        }
        Integer n = this.getUniformLocation(name);
        if (n == null) {
            return null;
        }
        int loc = n;
        DirectSamplerUniform uniform = new DirectSamplerUniform(loc, this.samplers.size(), this);
        this.samplers.put(name, uniform);
        return uniform;
    }

    private final void createShader() {
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)this.vertShader, (Object)this.vertSource), TuplesKt.to((Object)this.fragShader, (Object)this.fragSource)};
        for (Pair[] pairArray2 : CollectionsKt.listOf((Object[])pairArray2)) {
            int shader = ((Number)pairArray2.component1()).intValue();
            String source = (String)pairArray2.component2();
            if (CORE) {
                GL20.glShaderSource((int)shader, (CharSequence)source);
            } else {
                ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)source);
            }
            UGraphics.glCompileShader(shader);
            if (UGraphics.glGetShaderi(shader, 35713) != 1) {
                System.out.println((Object)UGraphics.glGetShaderInfoLog(shader, 32768));
                return;
            }
            UGraphics.glAttachShader(this.program, shader);
        }
        UGraphics.glLinkProgram(this.program);
        if (CORE) {
            GL20.glDetachShader((int)this.program, (int)this.vertShader);
            GL20.glDetachShader((int)this.program, (int)this.fragShader);
            GL20.glDeleteShader((int)this.vertShader);
            GL20.glDeleteShader((int)this.fragShader);
        } else {
            ARBShaderObjects.glDetachObjectARB((int)this.program, (int)this.vertShader);
            ARBShaderObjects.glDetachObjectARB((int)this.program, (int)this.fragShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.vertShader);
            ARBShaderObjects.glDeleteObjectARB((int)this.fragShader);
        }
        if (UGraphics.glGetProgrami(this.program, 35714) != 1) {
            System.out.println((Object)UGraphics.glGetProgramInfoLog(this.program, 32768));
            return;
        }
        if (CORE) {
            GL20.glValidateProgram((int)this.program);
        } else {
            ARBShaderObjects.glValidateProgramARB((int)this.program);
        }
        if (UGraphics.glGetProgrami(this.program, 35715) != 1) {
            System.out.println((Object)UGraphics.glGetProgramInfoLog(this.program, 32768));
            return;
        }
        this.setUsable(true);
    }

    @Override
    @NotNull
    public IntUniform getIntUniform(@NotNull String name) {
        return UShader.DefaultImpls.getIntUniform(this, name);
    }

    @Override
    @NotNull
    public FloatUniform getFloatUniform(@NotNull String name) {
        return UShader.DefaultImpls.getFloatUniform(this, name);
    }

    @Override
    @NotNull
    public Float2Uniform getFloat2Uniform(@NotNull String name) {
        return UShader.DefaultImpls.getFloat2Uniform(this, name);
    }

    @Override
    @NotNull
    public Float3Uniform getFloat3Uniform(@NotNull String name) {
        return UShader.DefaultImpls.getFloat3Uniform(this, name);
    }

    @Override
    @NotNull
    public Float4Uniform getFloat4Uniform(@NotNull String name) {
        return UShader.DefaultImpls.getFloat4Uniform(this, name);
    }

    @Override
    @NotNull
    public FloatMatrixUniform getFloatMatrixUniform(@NotNull String name) {
        return UShader.DefaultImpls.getFloatMatrixUniform(this, name);
    }

    @Override
    @NotNull
    public SamplerUniform getSamplerUniform(@NotNull String name) {
        return UShader.DefaultImpls.getSamplerUniform(this, name);
    }

    private static final Integer doBindTexture$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/universal/shader/GlShader$Companion;", "", "()V", "CORE", "", "getCORE", "()Z", "MSCore"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getCORE() {
            return CORE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

