/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.core.client.listener;

import gg.essential.elementa.components.GradientComponent;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UICircle;
import gg.essential.elementa.components.UIRoundedRectangle;
import gg.essential.elementa.font.FontRenderer;
import gg.essential.elementa.utils.ExtensionsKt;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.shader.Float4Uniform;
import gg.essential.universal.shader.FloatUniform;
import gg.essential.universal.shader.UShader;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mcskill.core.client.screen.MSFonts;
import net.mcskill.core.client.screen.component.MSRoundedRectangle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\fH\u0002J\u0006\u0010\u001a\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/mcskill/core/client/listener/ShaderPreLoader;", "", "()V", "shader", "Lgg/essential/universal/shader/UShader;", "shaderInnerRectUniform", "Lgg/essential/universal/shader/Float4Uniform;", "shaderRadiusUniform", "Lgg/essential/universal/shader/FloatUniform;", "shaderSmoothRadiusUniform", "shaderStrokeWidthUniform", "drawBorderedRoundedRect", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "left", "", "top", "right", "bottom", "radius", "smoothRadius", "strokeWidth", "color", "Ljava/awt/Color;", "initShaders", "registerShaders", "MSCore"})
public final class ShaderPreLoader {
    @NotNull
    public static final ShaderPreLoader INSTANCE = new ShaderPreLoader();
    private static UShader shader;
    private static FloatUniform shaderRadiusUniform;
    private static Float4Uniform shaderInnerRectUniform;
    private static FloatUniform shaderStrokeWidthUniform;
    private static FloatUniform shaderSmoothRadiusUniform;

    private ShaderPreLoader() {
    }

    private final void initShaders() {
        if (shader != null) {
            return;
        }
        shader = ExtensionsKt.readFromLegacyShader(UShader.Companion, "rect", "rounded_rect_stroke", BlendState.NORMAL);
        UShader uShader = shader;
        if (uShader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader = null;
        }
        if (!uShader.getUsable()) {
            System.out.println((Object)"Failed to load Elementa UIRoundedRectangle shader");
            return;
        }
        UShader uShader2 = shader;
        if (uShader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader2 = null;
        }
        shaderRadiusUniform = uShader2.getFloatUniform("u_Radius");
        UShader uShader3 = shader;
        if (uShader3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader3 = null;
        }
        shaderInnerRectUniform = uShader3.getFloat4Uniform("u_InnerRect");
        UShader uShader4 = shader;
        if (uShader4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader4 = null;
        }
        shaderStrokeWidthUniform = uShader4.getFloatUniform("u_StrokeWidth");
        UShader uShader5 = shader;
        if (uShader5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader5 = null;
        }
        shaderSmoothRadiusUniform = uShader5.getFloatUniform("u_SmoothRadius");
    }

    public final void drawBorderedRoundedRect(@NotNull UMatrixStack matrixStack, float left2, float top, float right, float bottom, float radius, float smoothRadius, float strokeWidth, @NotNull Color color) {
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                Intrinsics.checkNotNullParameter((Object)color, (String)"color");
                if (shader == null) break block10;
                UShader uShader = shader;
                if (uShader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
                    uShader = null;
                }
                if (uShader.getUsable()) break block11;
            }
            return;
        }
        UShader uShader = shader;
        if (uShader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader = null;
        }
        uShader.bind();
        FloatUniform floatUniform = shaderRadiusUniform;
        if (floatUniform == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shaderRadiusUniform");
            floatUniform = null;
        }
        floatUniform.setValue(radius);
        FloatUniform floatUniform2 = shaderSmoothRadiusUniform;
        if (floatUniform2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shaderSmoothRadiusUniform");
            floatUniform2 = null;
        }
        floatUniform2.setValue(smoothRadius);
        FloatUniform floatUniform3 = shaderStrokeWidthUniform;
        if (floatUniform3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shaderStrokeWidthUniform");
            floatUniform3 = null;
        }
        floatUniform3.setValue(strokeWidth);
        Float4Uniform float4Uniform = shaderInnerRectUniform;
        if (float4Uniform == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shaderInnerRectUniform");
            float4Uniform = null;
        }
        float4Uniform.setValue(left2 + radius, top + radius, right - radius, bottom - radius);
        UIBlock.Companion.drawBlockWithActiveShader(matrixStack, color, left2 - radius, top - radius, right + radius, bottom + radius);
        UShader uShader2 = shader;
        if (uShader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shader");
            uShader2 = null;
        }
        uShader2.unbind();
    }

    public final void registerShaders() {
        MSFonts.INSTANCE.register();
        this.initShaders();
        FontRenderer.Companion.initShaders();
        UICircle.Companion.initShaders();
        UIRoundedRectangle.Companion.initShaders();
        MSRoundedRectangle.Companion.initShaders();
        GradientComponent.Companion.initShaders();
    }
}

