/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.core.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import net.mcskill.core.common.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000b\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\u00020\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0006J2\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0006\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00142\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J5\u0010\u001d\u001a\u00020\u0014\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0006\u0010\u001f\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010 J(\u0010\u001d\u001a\u00020\u0014\"\b\b\u0000\u0010\u000f*\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00062\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J'\u0010!\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\"\u001a\u0002H\u000fH\u0002\u00a2\u0006\u0002\u0010#R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lnet/mcskill/core/common/config/ConfigRegister;", "", "()V", "_cachedConfigs", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "", "Lkotlin/reflect/KClass;", "_gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "configPath", "Ljava/nio/file/Path;", "getConfigPath", "()Ljava/nio/file/Path;", "createOrFind", "T", "configClass", "configName", "getConfigName", "loadConfig", "", "rewrite", "", "registry", "rewritable", "reloadAllConfig", "", "reloadConfig", "name", "saveConfig", "path", "data", "(Ljava/nio/file/Path;Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "setInstanceObject", "instance", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "MSCore"})
@SourceDebugExtension(value={"SMAP\nConfigRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigRegister.kt\nnet/mcskill/core/common/config/ConfigRegister\n+ 2 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n20#2:93\n29#2:107\n20#2:108\n288#3,2:94\n800#3,11:96\n288#3,2:109\n*S KotlinDebug\n*F\n+ 1 ConfigRegister.kt\nnet/mcskill/core/common/config/ConfigRegister\n*L\n42#1:93\n74#1:107\n74#1:108\n42#1:94,2\n73#1:96,11\n74#1:109,2\n*E\n"})
public final class ConfigRegister {
    @NotNull
    public static final ConfigRegister INSTANCE = new ConfigRegister();
    private static final Path configPath = FMLPaths.CONFIGDIR.get().resolve("mcskill-configs");
    @NotNull
    private static final Object2ObjectOpenHashMap<String, KClass<?>> _cachedConfigs = new Object2ObjectOpenHashMap();
    private static final Gson _gson = new GsonBuilder().setPrettyPrinting().create();

    private ConfigRegister() {
    }

    public final Path getConfigPath() {
        return configPath;
    }

    public final void registry(@NotNull KClass<?> configClass, boolean rewritable) {
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        this.loadConfig(configClass, this.getConfigName(configClass), rewritable);
    }

    public static /* synthetic */ void registry$default(ConfigRegister configRegister, KClass kClass, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        configRegister.registry(kClass, bl);
    }

    @NotNull
    public final String reloadConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KClass kClass = (KClass)_cachedConfigs.get((Object)name);
        if (kClass == null) {
            return ChatFormatting.RED + "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \"" + name + "\", \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430!";
        }
        KClass config = kClass;
        ConfigRegister.loadConfig$default(this, config, name, false, 4, null);
        return ChatFormatting.GREEN + "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \"" + name + "\" \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!";
    }

    @NotNull
    public final Set<String> reloadAllConfig() {
        ObjectOpenHashSet configNames = new ObjectOpenHashSet();
        for (KClass configClass : (ObjectCollection)_cachedConfigs.values()) {
            Intrinsics.checkNotNull((Object)configClass);
            String configName = this.getConfigName(configClass);
            ((Collection)configNames).add(configName);
            ConfigRegister.loadConfig$default(this, configClass, configName, false, 4, null);
        }
        return (Set)configNames;
    }

    @NotNull
    public final String getConfigName(@NotNull KClass<?> configClass) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)configClass;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof Config)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Config)((Annotation)v0)) == null || (object = object.name()) == null) {
            throw new RuntimeException("\u041a\u043b\u0430\u0441\u0441 \"" + configClass + "\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0430 \u0432 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 @Config.");
        }
        return object;
    }

    private final <T> void saveConfig(KClass<T> configClass, Path path) throws IOException {
        String string = _gson.toJson(KClasses.createInstance(configClass), (Type)JvmClassMappingKt.getJavaClass(configClass));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        PathsKt.writeText$default((Path)path, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final <T> void saveConfig(Path path, KClass<T> configClass, T data) throws IOException {
        String string = _gson.toJson(data, (Type)JvmClassMappingKt.getJavaClass(configClass));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        PathsKt.writeText$default((Path)path, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    private final <T> void loadConfig(KClass<T> configClass, String configName, boolean rewrite) throws IOException {
        Path path = configPath;
        Intrinsics.checkNotNull((Object)path);
        Object[] objectArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(objectArray, objectArray.length))) {
            path = configPath;
            Intrinsics.checkNotNull((Object)path);
            objectArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"createDirectories(this, *attributes)");
        }
        Path configFile = this.createOrFind(configClass, configName);
        String json2 = PathsKt.readText$default((Path)configFile, null, (int)1, null);
        Object object = _gson.fromJson(json2, JvmClassMappingKt.getJavaClass(configClass));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        Object instance = object;
        this.setInstanceObject(configClass, instance);
        ((Map)_cachedConfigs).put(configName, configClass);
        if (rewrite) {
            this.saveConfig(configFile, configClass, instance);
        }
    }

    static /* synthetic */ void loadConfig$default(ConfigRegister configRegister, KClass kClass, String string, boolean bl, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = false;
        }
        configRegister.loadConfig(kClass, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void setInstanceObject(KClass<?> configClass, T instance) {
        try {
            void $this$filterIsInstanceTo$iv$iv;
            KClass kClass = KClasses.getCompanionObject(configClass);
            if (kClass == null) {
                throw new IllegalAccessException();
            }
            KClass companion = kClass;
            Iterable $this$filterIsInstance$iv = KClasses.getDeclaredMemberProperties((KClass)companion);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KMutableProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (KMutableProperty field : (List)destination$iv$iv) {
                Object v1;
                block6: {
                    KAnnotatedElement $this$hasAnnotation$iv = (KAnnotatedElement)field;
                    boolean $i$f$hasAnnotation = false;
                    KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                    boolean $i$f$findAnnotation = false;
                    Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                        boolean bl = false;
                        if (!(it$iv$iv instanceof Config.Instance)) continue;
                        v1 = element$iv$iv$iv;
                        break block6;
                    }
                    v1 = null;
                }
                boolean bl = (Annotation)v1 != null;
                if (!bl) continue;
                KCallablesJvm.setAccessible((KCallable)((KCallable)field), (boolean)true);
                Object[] objectArray = new Object[]{KClasses.getCompanionObjectInstance(configClass), instance};
                field.getSetter().call(objectArray);
                break;
            }
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
    }

    private final <T> Path createOrFind(KClass<T> configClass, String configName) {
        Path configFile = configPath.resolve(configName + ".json");
        Intrinsics.checkNotNull((Object)configFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.saveConfig(configClass, configFile);
        }
        return configFile;
    }
}

