/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.core.common.network;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.mcskill.core.common.network.ChannelHandler;
import net.mcskill.core.common.network.NetworkExtensionKt;
import net.mcskill.core.common.network.Packet;
import net.mcskill.core.common.network.packet.ClipboardPacket;
import net.mcskill.core.common.network.packet.SyncAnimationPacket;
import net.mcskill.core.common.network.packet.SyncServerInfoPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/mcskill/core/common/network/ChannelHandler;", "", "()V", "PROTOCOL_VERSION", "", "_channel", "Lnet/minecraftforge/network/simple/SimpleChannel;", "_wasInitialized", "", "register", "", "send", "target", "Lnet/minecraftforge/network/PacketDistributor$PacketTarget;", "packet", "Lnet/mcskill/core/common/network/Packet;", "sendTo", "player", "Lnet/minecraft/server/level/ServerPlayer;", "MSCore"})
public final class ChannelHandler {
    @NotNull
    public static final ChannelHandler INSTANCE = new ChannelHandler();
    private static boolean _wasInitialized;
    @NotNull
    private static final String PROTOCOL_VERSION = "1.0.0";
    @NotNull
    private static final SimpleChannel _channel;

    private ChannelHandler() {
    }

    public final void register() {
        if (_wasInitialized) {
            return;
        }
        NetworkExtensionKt.registryPacket(_channel, 0, Reflection.getOrCreateKotlinClass(ClipboardPacket.class), register.1.INSTANCE);
        NetworkExtensionKt.registryPacket(_channel, 1, Reflection.getOrCreateKotlinClass(SyncServerInfoPacket.class), register.2.INSTANCE);
        NetworkExtensionKt.registryPacket(_channel, 2, Reflection.getOrCreateKotlinClass(SyncAnimationPacket.class), register.3.INSTANCE);
        _wasInitialized = true;
    }

    public final void sendTo(@NotNull Packet packet, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NetworkExtensionKt.sendTo(_channel, packet, player);
    }

    public final void send(@NotNull PacketDistributor.PacketTarget target, @NotNull Packet packet) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        _channel.send(target, (Object)packet);
    }

    private static final String _channel$lambda$0() {
        return PROTOCOL_VERSION;
    }

    static {
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mscore", "channel"), ChannelHandler::_channel$lambda$0, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(...)");
        _channel = simpleChannel;
    }
}

