/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.core.common.util;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.mcskill.core.common.util.TextFormatterKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u001aG\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"humanReadable", "", "Ljava/time/Duration;", "dayWords", "", "hourWords", "minuteWords", "secondWords", "(Ljava/time/Duration;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "MSCore"})
public final class TileUtilKt {
    @NotNull
    public static final String humanReadable(@NotNull Duration $this$humanReadable, @NotNull String[] dayWords, @NotNull String[] hourWords, @NotNull String[] minuteWords, @NotNull String[] secondWords) {
        long seconds;
        long minutes;
        long hours;
        Intrinsics.checkNotNullParameter((Object)$this$humanReadable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dayWords, (String)"dayWords");
        Intrinsics.checkNotNullParameter((Object)hourWords, (String)"hourWords");
        Intrinsics.checkNotNullParameter((Object)minuteWords, (String)"minuteWords");
        Intrinsics.checkNotNullParameter((Object)secondWords, (String)"secondWords");
        StringBuilder result = new StringBuilder();
        long days = $this$humanReadable.toDays();
        if (days != 0L) {
            result.append(TextFormatterKt.declension(days, dayWords));
        }
        if ((hours = $this$humanReadable.toHours() % 24L) != 0L) {
            if (((CharSequence)result).length() > 0) {
                result.append(' ');
            }
            result.append(TextFormatterKt.declension(hours, hourWords));
        }
        if ((minutes = $this$humanReadable.toMinutes() % 60L) != 0L) {
            if (((CharSequence)result).length() > 0) {
                result.append(' ');
            }
            result.append(TextFormatterKt.declension(minutes, minuteWords));
        }
        if ((seconds = $this$humanReadable.getSeconds() % 60L) != 0L || ((CharSequence)result).length() == 0) {
            if (((CharSequence)result).length() > 0) {
                result.append(' ');
            }
            result.append(TextFormatterKt.declension(seconds, secondWords));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

