/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.animatable;

import javax.annotation.Nullable;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.network.GeckoLibNetwork;
import net.mcskill.ghost.network.SerializableDataTicket;
import net.mcskill.ghost.network.packet.EntityAnimDataSyncPacket;
import net.mcskill.ghost.network.packet.EntityAnimTriggerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public interface GeoEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).m_19879_()).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        Entity entity = (Entity)this;
        if (entity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.send(new EntityAnimDataSyncPacket<D>(entity.m_19879_(), dataTicket, data), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        Entity entity = (Entity)this;
        if (entity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new EntityAnimTriggerPacket(entity.m_19879_(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((Entity)entity).f_19797_;
    }
}

