/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.animatable;

import java.util.EnumMap;
import java.util.Map;
import net.mcskill.ghost.animatable.SingletonGeoAnimatable;
import net.mcskill.ghost.cache.AnimatableIdCache;
import net.mcskill.ghost.constant.DataTickets;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.core.animatable.instance.AnimatableInstanceCache;
import net.mcskill.ghost.core.animatable.instance.SingletonAnimatableInstanceCache;
import net.mcskill.ghost.core.animation.AnimatableManager;
import net.mcskill.ghost.core.animation.ContextAwareAnimatableManager;
import net.mcskill.ghost.util.RenderUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "GeckoLibID";

    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        SingletonGeoAnimatable.registerSyncedAnimatable(animatable);
    }

    public static long getId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.m_128454_(ID_NBT_KEY);
    }

    public static long getOrAssignId(ItemStack stack, ServerLevel level) {
        CompoundTag tag = stack.m_41784_();
        long id2 = tag.m_128454_(ID_NBT_KEY);
        if (tag.m_128425_(ID_NBT_KEY, 99)) {
            return id2;
        }
        id2 = AnimatableIdCache.getFreeId(level);
        tag.m_128356_(ID_NBT_KEY, id2);
        return id2;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        @Override
        public AnimatableManager<?> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, (Object)new ContextAwareAnimatableManager<GeoItem, ItemDisplayContext>(this.animatable){

                    @Override
                    protected Map<ItemDisplayContext, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>> map2 = new EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>>(ItemDisplayContext.class);
                        for (ItemDisplayContext context : ItemDisplayContext.values()) {
                            map2.put(context, new AnimatableManager(animatable));
                        }
                        return map2;
                    }

                    @Override
                    public ItemDisplayContext getCurrentContext() {
                        ItemDisplayContext context = this.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemDisplayContext.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

