/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.animatable;

import javax.annotation.Nullable;
import net.mcskill.ghost.animatable.SingletonGeoAnimatable;
import net.mcskill.ghost.network.GeckoLibNetwork;
import net.mcskill.ghost.network.SerializableDataTicket;
import net.mcskill.ghost.network.packet.EntityAnimDataSyncPacket;
import net.mcskill.ghost.network.packet.EntityAnimTriggerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.network.PacketDistributor;

public interface GeoReplacedEntity
extends SingletonGeoAnimatable {
    public EntityType<?> getReplacingEntityType();

    @Nullable
    default public <D> D getAnimData(Entity entity, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(entity.m_19879_()).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.m_19879_()).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.send(new EntityAnimDataSyncPacket<D>(relatedEntity.m_19879_(), dataTicket, data), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public void triggerAnim(Entity relatedEntity, @Nullable String controllerName, String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.m_19879_()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new EntityAnimTriggerPacket(relatedEntity.m_19879_(), controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((Entity)entity).f_19797_;
    }
}

