/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.animatable;

import javax.annotation.Nullable;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.core.animatable.instance.AnimatableInstanceCache;
import net.mcskill.ghost.core.animatable.instance.SingletonAnimatableInstanceCache;
import net.mcskill.ghost.network.GeckoLibNetwork;
import net.mcskill.ghost.network.SerializableDataTicket;
import net.mcskill.ghost.network.packet.AnimDataSyncPacket;
import net.mcskill.ghost.network.packet.AnimTriggerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.PacketDistributor;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeckoLibNetwork.registerSyncedAnimatable(animatable);
    }

    @Nullable
    default public <D> D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, PacketDistributor.PacketTarget packetTarget) {
        GeckoLibNetwork.send(new AnimDataSyncPacket<D>(this.getClass().toString(), instanceId, dataTicket, data), packetTarget);
    }

    default public <D> void triggerAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new AnimTriggerPacket(this.getClass().toString(), instanceId, controllerName, animName), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> relatedEntity));
        }
    }

    default public <D> void triggerAnim(long instanceId, @Nullable String controllerName, String animName, PacketDistributor.PacketTarget packetTarget) {
        GeckoLibNetwork.send(new AnimTriggerPacket(this.getClass().toString(), instanceId, controllerName, animName), packetTarget);
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }
}

