/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.cache;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public final class AnimatableIdCache
extends SavedData {
    private static final String DATA_KEY = "geckolib_id_cache";
    private long lastId;

    private AnimatableIdCache() {
        this(new CompoundTag());
    }

    private AnimatableIdCache(CompoundTag tag) {
        this.lastId = tag.m_128454_("last_id");
    }

    public static long getFreeId(ServerLevel level) {
        return AnimatableIdCache.getCache(level).getNextId();
    }

    private long getNextId() {
        this.m_77762_();
        return ++this.lastId;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_("last_id", this.lastId);
        return tag;
    }

    private static AnimatableIdCache getCache(ServerLevel level) {
        AnimatableIdCache legacyCache;
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        AnimatableIdCache cache = (AnimatableIdCache)storage.m_164861_(AnimatableIdCache::new, AnimatableIdCache::new, DATA_KEY);
        if (cache.lastId == 0L && (legacyCache = (AnimatableIdCache)storage.m_164858_(AnimatableIdCache::fromLegacy, "geckolib_ids")) != null) {
            cache.lastId = legacyCache.lastId;
        }
        return cache;
    }

    private static AnimatableIdCache fromLegacy(CompoundTag tag) {
        AnimatableIdCache legacyCache = new AnimatableIdCache();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 99)) continue;
            legacyCache.lastId = Math.max(legacyCache.lastId, (long)tag.m_128451_(key));
        }
        return legacyCache;
    }
}

