/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.mcskill.ghost.GhostRegister;
import net.mcskill.ghost.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;

public class AnimatableTexture
extends SimpleTexture {
    private AnimationContents animationContents = null;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Resource resource = manager.m_215593_(this.f_118129_);
        try {
            NativeImage nativeImage;
            try (InputStream inputstream = resource.m_215507_();){
                nativeImage = NativeImage.m_85058_((InputStream)inputstream);
            }
            this.animationContents = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).map(animMeta -> new AnimationContents(nativeImage, (AnimationMetadataSection)animMeta)).orElse(null);
            if (this.animationContents != null) {
                if (!this.animationContents.isValid()) {
                    nativeImage.close();
                    return;
                }
                AnimatableTexture.onRenderThread(() -> {
                    TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)this.animationContents.frameSize.f_244129_(), (int)this.animationContents.frameSize.f_244503_());
                    nativeImage.m_85003_(0, 0, 0, 0, 0, this.animationContents.frameSize.f_244129_(), this.animationContents.frameSize.f_244503_(), false, false);
                });
                return;
            }
        }
        catch (RuntimeException exception) {
            GhostRegister.LOGGER.warn("Failed reading metadata of: {}", (Object)this.f_118129_, (Object)exception);
        }
        super.m_6704_(manager);
    }

    public static void setAndUpdate(ResourceLocation texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtils.getCurrentTick());
    }

    public static void setAndUpdate(ResourceLocation texturePath, int frameTick) {
        AbstractTexture texture2 = Minecraft.m_91087_().m_91097_().m_118506_(texturePath);
        if (texture2 instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture2;
            animatableTexture.setAnimationFrame(frameTick);
        }
        RenderSystem.setShaderTexture((int)0, (int)texture2.m_117963_());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private static void onRenderThread(RenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.m_83909_();
        }
    }

    private class AnimationContents {
        private final FrameSize frameSize;
        private final Texture animatedTexture;

        private AnimationContents(NativeImage image, AnimationMetadataSection animMeta) {
            this.frameSize = animMeta.m_245821_(image.m_84982_(), image.m_85084_());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        private Texture generateAnimatedTexture(NativeImage image, AnimationMetadataSection animMeta) {
            if (!Mth.m_264612_((int)image.m_84982_(), (int)this.frameSize.f_244129_()) || !Mth.m_264612_((int)image.m_85084_(), (int)this.frameSize.f_244503_())) {
                GhostRegister.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.f_118129_, (Object)image.m_84982_(), (Object)image.m_85084_(), (Object)this.frameSize.f_244129_(), (Object)this.frameSize.f_244503_());
                return null;
            }
            int columns = image.m_84982_() / this.frameSize.f_244129_();
            int rows = image.m_85084_() / this.frameSize.f_244503_();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            animMeta.m_174861_((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.m_119030_()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        GhostRegister.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)index, (Object)frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        GhostRegister.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)index, (Object)frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    GhostRegister.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)Arrays.toString(unusedFrames.toArray()));
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.m_119036_());
        }

        private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        private class Texture
        implements AutoCloseable {
            private final NativeImage baseImage;
            private final Frame[] frames;
            private final int framePanelSize;
            private final boolean interpolating;
            private final NativeImage interpolatedFrame;
            private final int totalFrameTime;
            private int currentFrame;
            private int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(AnimationContents.this.frameSize.f_244129_(), AnimationContents.this.frameSize.f_244503_(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.prepareImage((int)AnimatableTexture.this.m_117963_(), (int)0, (int)AnimationContents.this.frameSize.f_244129_(), (int)AnimationContents.this.frameSize.f_244503_());
                        this.baseImage.m_85003_(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.f_244129_(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.f_244503_(), AnimationContents.this.frameSize.f_244129_(), AnimationContents.this.frameSize.f_244503_(), false, false);
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(this::generateInterpolatedFrame);
                }
            }

            private void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.m_85084_(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.m_84982_(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.m_84988_(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.prepareImage((int)AnimatableTexture.this.m_117963_(), (int)0, (int)AnimationContents.this.frameSize.f_244129_(), (int)AnimationContents.this.frameSize.f_244503_());
                    this.interpolatedFrame.m_85003_(0, 0, 0, 0, 0, AnimationContents.this.frameSize.f_244129_(), AnimationContents.this.frameSize.f_244503_(), false, false);
                }
            }

            private int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.m_84985_(x + this.getFrameX(frameIndex) * AnimationContents.this.frameSize.f_244129_(), y + this.getFrameY(frameIndex) * AnimationContents.this.frameSize.f_244503_());
            }

            private int interpolate(double frameProgress, double prevColour, double nextColour) {
                return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        private record Frame(int index, int time) {
        }
    }
}

