/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.mcskill.ghost.GhostRegister;
import net.mcskill.ghost.loading.json.raw.Model;
import net.mcskill.ghost.loading.object.BakedAnimations;
import net.mcskill.ghost.util.JsonUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class FileLoader {
    public static BakedAnimations loadAnimationsFile(ResourceLocation location, ResourceManager manager) {
        return (BakedAnimations)JsonUtil.GEO_GSON.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)FileLoader.loadFile(location, manager), (String)"animations"), BakedAnimations.class);
    }

    public static Model loadModelFile(ResourceLocation location, ResourceManager manager) {
        return (Model)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), Model.class);
    }

    public static JsonObject loadFile(ResourceLocation location, ResourceManager manager) {
        return (JsonObject)GsonHelper.m_13794_((Gson)JsonUtil.GEO_GSON, (String)FileLoader.getFileContents(location, manager), JsonObject.class);
    }

    public static String getFileContents(ResourceLocation location, ResourceManager manager) {
        String locAsString = location.toString();
        if (locAsString.endsWith(".msm") || locAsString.endsWith(".msa")) {
            return FileLoader.readSecure(manager, location);
        }
        return FileLoader.readInsecure(manager, location);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readSecure(ResourceManager manager, ResourceLocation location) {
        try (InputStream inputStream = manager.m_215593_(location).m_215507_();){
            String string;
            try (ByteArrayInputStream input = new ByteArrayInputStream(FileLoader.transform(IOUtils.toByteArray((InputStream)inputStream)));){
                string = IOUtils.toString((InputStream)input, (Charset)Charset.defaultCharset());
            }
            return string;
        }
        catch (IOException e) {
            String message = "Couldn't load " + location;
            GhostRegister.LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(new FileNotFoundException(location.toString()));
        }
    }

    private static String readInsecure(ResourceManager manager, ResourceLocation location) {
        String string;
        block8: {
            InputStream inputStream = manager.m_215593_(location).m_215507_();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = "Couldn't load " + location;
                    GhostRegister.LOGGER.error(message, (Throwable)e);
                    throw new RuntimeException(new FileNotFoundException(location.toString()));
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static byte[] transform(byte[] bytes) {
        int i2;
        int s = bytes.length - 4;
        for (i2 = 0; i2 <= s; i2 += 4) {
            ArrayUtils.reverse((byte[])bytes, (int)i2, (int)(i2 + 4));
        }
        i2 = 0;
        while (i2 < bytes.length) {
            int n = i2++;
            bytes[n] = ~bytes[n];
        }
        return bytes;
    }
}

