/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.mcskill.ghost.loading.json.raw.Bone;
import net.mcskill.ghost.loading.json.raw.MinecraftGeometry;
import net.mcskill.ghost.loading.json.raw.Model;
import net.mcskill.ghost.loading.json.raw.ModelProperties;
import net.mcskill.ghost.loading.object.BoneStructure;

public record GeometryTree(Map<String, BoneStructure> topLevelBones, ModelProperties properties) {
    public static GeometryTree fromModel(Model model) {
        Object2ObjectOpenHashMap topLevelBones = new Object2ObjectOpenHashMap();
        MinecraftGeometry geometry = model.minecraftGeometry()[0];
        Bone[] bones = geometry.bones();
        Object2ObjectOpenHashMap lookup = new Object2ObjectOpenHashMap(bones.length);
        for (Bone bone : bones) {
            BoneStructure boneStructure = new BoneStructure(bone);
            lookup.put(bone.name(), boneStructure);
            if (bone.parent() != null) continue;
            topLevelBones.put(bone.name(), boneStructure);
        }
        for (Bone bone : bones) {
            String parentName = bone.parent();
            if (parentName == null) continue;
            String boneName = bone.name();
            if (parentName.equals(boneName)) {
                throw new IllegalArgumentException("Invalid model definition. Bone has defined itself as its own parent: " + boneName);
            }
            BoneStructure parentStructure = (BoneStructure)lookup.get(parentName);
            if (parentStructure == null) {
                throw new IllegalArgumentException("Invalid model definition. Found bone with undefined parent (child -> parent): " + boneName + " -> " + parentName);
            }
            parentStructure.children().put(boneName, (BoneStructure)lookup.get(boneName));
        }
        return new GeometryTree((Map<String, BoneStructure>)topLevelBones, geometry.modelProperties());
    }

    @Deprecated(forRemoval=true)
    private static BoneStructure findBoneStructureInTree(Map<String, BoneStructure> bones, String boneName) {
        for (BoneStructure entry : bones.values()) {
            if (boneName.equals(entry.self().name())) {
                return entry;
            }
            BoneStructure subStructure = GeometryTree.findBoneStructureInTree(entry.children(), boneName);
            if (subStructure == null) continue;
            return subStructure;
        }
        return null;
    }
}

