/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.mcskill.ghost.GhostRegister;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.network.packet.AnimDataSyncPacket;
import net.mcskill.ghost.network.packet.AnimTriggerPacket;
import net.mcskill.ghost.network.packet.BlockEntityAnimDataSyncPacket;
import net.mcskill.ghost.network.packet.BlockEntityAnimTriggerPacket;
import net.mcskill.ghost.network.packet.EntityAnimDataSyncPacket;
import net.mcskill.ghost.network.packet.EntityAnimTriggerPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class GeckoLibNetwork {
    private static final String VER = "1";
    private static final SimpleChannel PACKET_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("ghost_channel", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    public static void init() {
        int id2 = 0;
        PACKET_CHANNEL.registerMessage(id2++, AnimDataSyncPacket.class, AnimDataSyncPacket::encode, AnimDataSyncPacket::decode, AnimDataSyncPacket::receivePacket);
        PACKET_CHANNEL.registerMessage(id2++, AnimTriggerPacket.class, AnimTriggerPacket::encode, AnimTriggerPacket::decode, AnimTriggerPacket::receivePacket);
        PACKET_CHANNEL.registerMessage(id2++, EntityAnimDataSyncPacket.class, EntityAnimDataSyncPacket::encode, EntityAnimDataSyncPacket::decode, EntityAnimDataSyncPacket::receivePacket);
        PACKET_CHANNEL.registerMessage(id2++, EntityAnimTriggerPacket.class, EntityAnimTriggerPacket::encode, EntityAnimTriggerPacket::decode, EntityAnimTriggerPacket::receivePacket);
        PACKET_CHANNEL.registerMessage(id2++, BlockEntityAnimDataSyncPacket.class, BlockEntityAnimDataSyncPacket::encode, BlockEntityAnimDataSyncPacket::decode, BlockEntityAnimDataSyncPacket::receivePacket);
        PACKET_CHANNEL.registerMessage(id2++, BlockEntityAnimTriggerPacket.class, BlockEntityAnimTriggerPacket::encode, BlockEntityAnimTriggerPacket::decode, BlockEntityAnimTriggerPacket::receivePacket);
    }

    public static synchronized void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);
        if (existing == null) {
            GhostRegister.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getClass().toString());
        }
    }

    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            GhostRegister.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");
        }
        return animatable;
    }

    public static <M> void send(M packet, PacketDistributor.PacketTarget distributor) {
        PACKET_CHANNEL.send(distributor, packet);
    }
}

