/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.network;

import net.mcskill.ghost.core.object.DataTicket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public abstract class SerializableDataTicket<D>
extends DataTicket<D> {
    public SerializableDataTicket(String id2, Class<? extends D> objectType) {
        super(id2, objectType);
    }

    public abstract void encode(D var1, FriendlyByteBuf var2);

    public abstract D decode(FriendlyByteBuf var1);

    public static SerializableDataTicket<Double> ofDouble(ResourceLocation id2) {
        return new SerializableDataTicket<Double>(id2.toString(), Double.class){

            @Override
            public void encode(Double data, FriendlyByteBuf buffer) {
                buffer.writeDouble(data.doubleValue());
            }

            @Override
            public Double decode(FriendlyByteBuf buffer) {
                return buffer.readDouble();
            }
        };
    }

    public static SerializableDataTicket<Float> ofFloat(ResourceLocation id2) {
        return new SerializableDataTicket<Float>(id2.toString(), Float.class){

            @Override
            public void encode(Float data, FriendlyByteBuf buffer) {
                buffer.writeFloat(data.floatValue());
            }

            @Override
            public Float decode(FriendlyByteBuf buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        };
    }

    public static SerializableDataTicket<Boolean> ofBoolean(ResourceLocation id2) {
        return new SerializableDataTicket<Boolean>(id2.toString(), Boolean.class){

            @Override
            public void encode(Boolean data, FriendlyByteBuf buffer) {
                buffer.writeBoolean(data.booleanValue());
            }

            @Override
            public Boolean decode(FriendlyByteBuf buffer) {
                return buffer.readBoolean();
            }
        };
    }

    public static SerializableDataTicket<Integer> ofInt(ResourceLocation id2) {
        return new SerializableDataTicket<Integer>(id2.toString(), Integer.class){

            @Override
            public void encode(Integer data, FriendlyByteBuf buffer) {
                buffer.m_130130_(data.intValue());
            }

            @Override
            public Integer decode(FriendlyByteBuf buffer) {
                return buffer.m_130242_();
            }
        };
    }

    public static SerializableDataTicket<String> ofString(ResourceLocation id2) {
        return new SerializableDataTicket<String>(id2.toString(), String.class){

            @Override
            public void encode(String data, FriendlyByteBuf buffer) {
                buffer.m_130070_(data);
            }

            @Override
            public String decode(FriendlyByteBuf buffer) {
                return buffer.m_130277_();
            }
        };
    }

    public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(ResourceLocation id2, final Class<E> enumClass) {
        return new SerializableDataTicket<E>(id2.toString(), enumClass){

            @Override
            public void encode(E data, FriendlyByteBuf buffer) {
                buffer.m_130070_(((Enum)data).toString());
            }

            @Override
            public E decode(FriendlyByteBuf buffer) {
                return Enum.valueOf(enumClass, buffer.m_130277_());
            }
        };
    }
}

