/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.network.packet;

import java.util.function.Supplier;
import net.mcskill.ghost.animatable.SingletonGeoAnimatable;
import net.mcskill.ghost.constant.DataTickets;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.network.GeckoLibNetwork;
import net.mcskill.ghost.network.SerializableDataTicket;
import net.mcskill.ghost.util.ClientUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class AnimDataSyncPacket<D> {
    private final String syncableId;
    private final long instanceId;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public AnimDataSyncPacket(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.syncableId);
        buffer.m_130103_(this.instanceId);
        buffer.m_130070_(this.dataTicket.id());
        this.dataTicket.encode(this.data, buffer);
    }

    public static <D> AnimDataSyncPacket<D> decode(FriendlyByteBuf buffer) {
        String syncableId = buffer.m_130277_();
        long instanceId = buffer.m_130258_();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buffer.m_130277_());
        Object data = dataTicket.decode(buffer);
        return new AnimDataSyncPacket(syncableId, instanceId, dataTicket, data);
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable instanceof SingletonGeoAnimatable) {
                SingletonGeoAnimatable singleton = (SingletonGeoAnimatable)animatable;
                singleton.setAnimData((Entity)ClientUtils.getClientPlayer(), this.instanceId, this.dataTicket, this.data);
            }
        });
        handler.setPacketHandled(true);
    }
}

