/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.core.animation.AnimatableManager;
import net.mcskill.ghost.network.GeckoLibNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class AnimTriggerPacket<D> {
    private final String syncableId;
    private final long instanceId;
    private final String controllerName;
    private final String animName;

    public AnimTriggerPacket(String syncableId, long instanceId, @Nullable String controllerName, String animName) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.syncableId);
        buffer.m_130103_(this.instanceId);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static <D> AnimTriggerPacket<D> decode(FriendlyByteBuf buffer) {
        return new AnimTriggerPacket<D>(buffer.m_130277_(), buffer.m_130258_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(this.syncableId);
            if (animatable != null) {
                AnimatableManager manager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId);
                manager.tryTriggerAnimation(this.controllerName, this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

