/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mcskill.ghost.animatable.GeoBlockEntity;
import net.mcskill.ghost.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntityAnimTriggerPacket<D> {
    private final BlockPos pos;
    private final String controllerName;
    private final String animName;

    public BlockEntityAnimTriggerPacket(BlockPos pos, @Nullable String controllerName, String animName) {
        this.pos = pos;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static <D> BlockEntityAnimTriggerPacket<D> decode(FriendlyByteBuf buffer) {
        return new BlockEntityAnimTriggerPacket<D>(buffer.m_130135_(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            BlockEntity blockEntity = ClientUtils.getLevel().m_7702_(this.pos);
            if (blockEntity instanceof GeoBlockEntity) {
                GeoBlockEntity getBlockEntity = (GeoBlockEntity)blockEntity;
                getBlockEntity.triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

