/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.mcskill.ghost.cache.object.BakedGeoModel;
import net.mcskill.ghost.cache.object.GeoBone;
import net.mcskill.ghost.cache.texture.AnimatableTexture;
import net.mcskill.ghost.constant.DataTickets;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.core.animation.AnimationState;
import net.mcskill.ghost.event.GeoRenderEvent;
import net.mcskill.ghost.model.GeoModel;
import net.mcskill.ghost.model.data.EntityModelData;
import net.mcskill.ghost.renderer.GeoRenderer;
import net.mcskill.ghost.renderer.layer.GeoRenderLayer;
import net.mcskill.ghost.renderer.layer.GeoRenderLayersContainer;
import net.mcskill.ghost.util.RenderUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GeoEntityRenderer<T extends Entity>
extends EntityRenderer<T>
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoEntityRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager);
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(T animatable) {
        return animatable.m_19879_();
    }

    public ResourceLocation m_5478_(T animatable) {
        return GeoRenderer.super.getTextureLocation(animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoEntityRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void m_7392_(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.animatable = entity;
        this.defaultRender(poseStack, (GeoAnimatable)entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction bedDirection;
        Entity entity;
        LivingEntity entity2;
        poseStack.m_85836_();
        LivingEntity livingEntity = animatable instanceof LivingEntity ? (entity2 = (LivingEntity)animatable) : null;
        boolean shouldSit = animatable.m_20159_() && animatable.m_20202_() != null && animatable.m_20202_().shouldRiderSit();
        float lerpBodyRot = livingEntity == null ? 0.0f : Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
        float lerpHeadRot = livingEntity == null ? 0.0f : Mth.m_14189_((float)partialTick, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity = animatable.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.m_20089_() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.m_21259_()) != null) {
            float eyePosOffset = livingEntity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-bedDirection.m_122429_()) * eyePosOffset, 0.0f, (float)(-bedDirection.m_122431_()) * eyePosOffset);
        }
        float ageInTicks = (float)((Entity)animatable).f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && animatable.m_6084_() && livingEntity != null) {
            limbSwingAmount = livingEntity.f_267362_.m_267711_(partialTick);
            limbSwing = livingEntity.f_267362_.m_267590_(partialTick);
            if (livingEntity.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = Mth.m_14179_((float)partialTick, (float)((Entity)animatable).f_19860_, (float)animatable.m_146909_());
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = animatable.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            AnimationState<T> animationState = new AnimationState<T>(animatable, limbSwing, limbSwingAmount, partialTick, avgVelocity >= motionThreshold && limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId(animatable);
            GeoModel<Object> currentModel = this.getGeoModel();
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
            animationState.setData(DataTickets.ENTITY, animatable);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.m_6162_(), -netHeadYaw, -headPitch));
            currentModel.addAdditionalStateData(animatable, instanceId, animationState::setData);
            currentModel.handleAnimations(animatable, instanceId, (AnimationState<Object>)animationState);
        }
        poseStack.m_252880_(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            if (Minecraft.m_91087_().m_91314_(animatable)) {
                renderType = RenderType.m_110491_((ResourceLocation)this.m_5478_(animatable));
                buffer = bufferSource.m_6299_(renderType);
            } else {
                renderType = null;
            }
        }
        if (renderType != null) {
            GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    @Override
    public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.m_5833_()) {
            GeoRenderer.super.applyRenderLayers(poseStack, animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    @Override
    public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Mob mob;
        Entity leashHolder;
        super.m_7392_(animatable, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (animatable instanceof Mob && (leashHolder = (mob = (Mob)animatable).m_21524_()) != null) {
            this.renderLeash(mob, partialTick, poseStack, bufferSource, leashHolder);
        }
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.m_7860_((Entity)this.animatable, 1.0f).m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.animatable.m_20182_().m_252839_()));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        LivingEntity entity;
        LivingEntity livingEntity;
        Pose pose = animatable.m_20089_();
        LivingEntity livingEntity2 = livingEntity = animatable instanceof LivingEntity ? (entity = (LivingEntity)animatable) : null;
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((Entity)animatable).f_19797_ * 3.25) * Math.PI * 0.4);
        }
        if (pose != Pose.SLEEPING) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        }
        if (livingEntity != null && livingEntity.f_20919_ > 0) {
            float deathRotation = ((float)livingEntity.f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (livingEntity != null && livingEntity.m_21209_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - livingEntity.m_146909_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)livingEntity.f_19797_ + partialTick) * -75.0f));
        } else if (livingEntity != null && pose == Pose.SLEEPING) {
            Direction bedOrientation = livingEntity.m_21259_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.getDeathMaxRotation(animatable)));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (animatable.m_8077_() || animatable instanceof Player) {
            String name = animatable.m_7755_().getString();
            if (animatable instanceof Player) {
                Player player = (Player)animatable;
                if (!player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = ChatFormatting.m_126649_((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.m_252880_(0.0f, animatable.m_20206_() + 0.1f, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(T animatable) {
        return animatable.m_20163_() ? 32.0 : 64.0;
    }

    public boolean m_6512_(T animatable) {
        if (!(animatable instanceof LivingEntity)) {
            return super.m_6512_(animatable);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(animatable);
        if (this.f_114476_.m_114471_(animatable) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(animatable instanceof Mob) || animatable.m_6052_() || animatable.m_8077_() && animatable == this.f_114476_.f_114359_)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        boolean visibleToClient = !animatable.m_20177_((Player)minecraft.f_91074_);
        Team entityTeam = animatable.m_5647_();
        if (entityTeam == null) {
            return Minecraft.m_91404_() && animatable != minecraft.m_91288_() && visibleToClient && !animatable.m_20160_();
        }
        Team playerTeam = minecraft.f_91074_.m_5647_();
        return switch (entityTeam.m_7470_()) {
            default -> throw new IncompatibleClassChangeError();
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.m_83536_(playerTeam) && (entityTeam.m_6259_() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.m_83536_(playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(T animatable, float u) {
        if (!(animatable instanceof LivingEntity)) {
            return OverlayTexture.f_118083_;
        }
        LivingEntity entity = (LivingEntity)animatable;
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)u), (int)OverlayTexture.m_118096_((entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 1 : 0) != 0));
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        return this.getPackedOverlay(animatable, u);
    }

    public boolean isShaking(T animatable) {
        return animatable.m_146890_();
    }

    public <E extends Entity, M extends Mob> void renderLeash(M mob, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.m_14179_((float)partialTick, (float)mob.f_20884_, (float)mob.f_20883_) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = mob.m_7939_();
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.f_82481_ + Math.sin(lerpBodyAngle) * leashOffset.f_82479_;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.f_82481_ - Math.cos(lerpBodyAngle) * leashOffset.f_82479_;
        double lerpOriginX = Mth.m_14139_((double)partialTick, (double)mob.f_19854_, (double)mob.m_20185_()) + xAngleOffset;
        double lerpOriginY = Mth.m_14139_((double)partialTick, (double)mob.f_19855_, (double)mob.m_20186_()) + leashOffset.f_82480_;
        double lerpOriginZ = Mth.m_14139_((double)partialTick, (double)mob.f_19856_, (double)mob.m_20189_()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.m_7398_(partialTick);
        float xDif = (float)(ropeGripPosition.f_82479_ - lerpOriginX);
        float yDif = (float)(ropeGripPosition.f_82480_ - lerpOriginY);
        float zDif = (float)(ropeGripPosition.f_82481_ - lerpOriginZ);
        float offsetMod = Mth.m_264536_((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        BlockPos entityEyePos = BlockPos.m_274446_((Position)mob.m_20299_(partialTick));
        BlockPos holderEyePos = BlockPos.m_274446_((Position)leashHolder.m_20299_(partialTick));
        int entityBlockLight = this.m_6086_((Entity)mob, entityEyePos);
        int holderBlockLight = leashHolder.m_6060_() ? 15 : leashHolder.m_9236_().m_45517_(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = mob.m_9236_().m_45517_(LightLayer.SKY, entityEyePos);
        int holderSkyLight = mob.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        poseStack.m_85836_();
        poseStack.m_85837_(xAngleOffset, leashOffset.f_82480_, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        for (segment = 0; segment <= 24; ++segment) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.m_109885_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.m_252986_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.m_5478_(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        MinecraftForge.EVENT_BUS.post((Event)new GeoRenderEvent.Entity.CompileRenderLayers(this));
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return !MinecraftForge.EVENT_BUS.post((Event)new GeoRenderEvent.Entity.Pre(this, poseStack, model, bufferSource, partialTick, packedLight));
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        MinecraftForge.EVENT_BUS.post((Event)new GeoRenderEvent.Entity.Post(this, poseStack, model, bufferSource, partialTick, packedLight));
    }
}

