/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.util;

import net.mcskill.ghost.constant.DataTickets;
import net.mcskill.ghost.core.animatable.GeoAnimatable;
import net.mcskill.ghost.core.animatable.instance.AnimatableInstanceCache;
import net.mcskill.ghost.core.animatable.instance.InstancedAnimatableInstanceCache;
import net.mcskill.ghost.core.animatable.instance.SingletonAnimatableInstanceCache;
import net.mcskill.ghost.core.animation.Animation;
import net.mcskill.ghost.core.animation.EasingType;
import net.mcskill.ghost.loading.object.BakedModelFactory;
import net.mcskill.ghost.network.SerializableDataTicket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class GeckoLibUtil {
    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        return cache != null ? cache : GeckoLibUtil.createInstanceCache(animatable, !(animatable instanceof Entity) && !(animatable instanceof BlockEntity));
    }

    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable, boolean singletonObject) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        if (cache != null) {
            return cache;
        }
        return singletonObject ? new SingletonAnimatableInstanceCache(animatable) : new InstancedAnimatableInstanceCache(animatable);
    }

    public static synchronized Animation.LoopType addCustomLoopType(String name, Animation.LoopType loopType) {
        return Animation.LoopType.register(name, loopType);
    }

    public static synchronized EasingType addCustomEasingType(String name, EasingType easingType) {
        return EasingType.register(name, easingType);
    }

    public static synchronized void addCustomBakedModelFactory(String namespace, BakedModelFactory factory2) {
        BakedModelFactory.register(namespace, factory2);
    }

    public static synchronized <D> SerializableDataTicket<D> addDataTicket(SerializableDataTicket<D> dataTicket) {
        return DataTickets.registerSerializable(dataTicket);
    }
}

