/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.ghost.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mcskill.ghost.core.animation.Animation;
import net.mcskill.ghost.loading.json.raw.Bone;
import net.mcskill.ghost.loading.json.raw.Cube;
import net.mcskill.ghost.loading.json.raw.FaceUV;
import net.mcskill.ghost.loading.json.raw.LocatorClass;
import net.mcskill.ghost.loading.json.raw.LocatorValue;
import net.mcskill.ghost.loading.json.raw.MinecraftGeometry;
import net.mcskill.ghost.loading.json.raw.Model;
import net.mcskill.ghost.loading.json.raw.ModelProperties;
import net.mcskill.ghost.loading.json.raw.PolyMesh;
import net.mcskill.ghost.loading.json.raw.PolysUnion;
import net.mcskill.ghost.loading.json.raw.TextureMesh;
import net.mcskill.ghost.loading.json.raw.UVFaces;
import net.mcskill.ghost.loading.json.raw.UVUnion;
import net.mcskill.ghost.loading.json.typeadapter.BakedAnimationsAdapter;
import net.mcskill.ghost.loading.json.typeadapter.KeyFramesAdapter;
import net.mcskill.ghost.loading.object.BakedAnimations;
import net.minecraft.util.GsonHelper;

public final class JsonUtil {
    public static final Gson GEO_GSON = new GsonBuilder().setLenient().registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(MinecraftGeometry.class, MinecraftGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(ModelProperties.class, ModelProperties.deserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).registerTypeAdapter(Animation.Keyframes.class, (Object)new KeyFramesAdapter()).registerTypeAdapter(BakedAnimations.class, (Object)new BakedAnimationsAdapter()).create();

    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i2 = 0; i2 < array.size(); ++i2) {
            output[i2] = array.get(i2).getAsDouble();
        }
        return output;
    }

    public static <T> T[] jsonArrayToObjectArray(JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i2 = 0; i2 < array.size(); ++i2) {
            objArray[i2] = context.deserialize(array.get(i2), objectClass);
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> Map<String, T> jsonObjToMap(JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        Object2ObjectOpenHashMap map2 = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map2.put((String)entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map2;
    }

    @Nullable
    public static Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(GsonHelper.m_13921_((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(GsonHelper.m_13912_((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(GsonHelper.m_13915_((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(GsonHelper.m_144784_((JsonObject)obj, (String)elementName)) : null;
    }

    @Nullable
    public static Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(GsonHelper.m_13927_((JsonObject)obj, (String)elementName)) : null;
    }
}

