#version 130

out vec4 out_Color;

uniform sampler2D image;
uniform sampler2D imageBack;

uniform bool horizontal;
uniform float width;
uniform float height;

const float weight[41] = float[] (
    0.005633, 0.006845, 0.008235, 0.009808, 0.011566,
    0.013504, 0.015609, 0.017863, 0.020239, 0.022704,
    0.025215, 0.027726, 0.030183, 0.032532, 0.034715,
    0.036676, 0.038363, 0.039728, 0.040733, 0.041348,
    0.041555,
    0.041348, 0.040733, 0.039728, 0.038363, 0.036676,
    0.034715, 0.032532, 0.030183, 0.027726, 0.025215,
    0.022704, 0.020239, 0.017863, 0.015609, 0.013504,
    0.011566, 0.009808, 0.008235, 0.006845, 0.005633
);

void main() {
    vec2 tex_offset = 1.0 / vec2(width, height);
    vec4 result = texture(image, gl_TexCoord[0].xy) * weight[20];
    vec2 texPos = horizontal ? vec2(tex_offset.x, 0.0) : vec2(0.0, tex_offset.y);

    for (int i = -20; i < 21; ++i) {
        vec2 actualPos = gl_TexCoord[0].xy + texPos * i;
        vec4 up = texture(image, actualPos);
        vec4 upBack = texture(imageBack, actualPos);
        vec4 mixUp = vec4(mix(upBack.rgb, up.rgb, up.a), up.a);

        result += mixUp * weight[20 + i];
    }
    out_Color = result;
}