/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.shop.client.screen.component;

import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.ExtensionsKt;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J>\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003J.\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011J6\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0015"}, d2={"Lnet/mcskill/shop/client/screen/component/TriangleBlock;", "Lgg/essential/elementa/UIComponent;", "color", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;)V", "Lgg/essential/elementa/constraints/ColorConstraint;", "(Lgg/essential/elementa/constraints/ColorConstraint;)V", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawTriangle", "tess", "Lgg/essential/universal/UGraphics;", "x", "", "y", "w", "h", "MSShop"})
public final class TriangleBlock
extends UIComponent {
    public TriangleBlock(@NotNull ColorConstraint color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.setColor(color);
    }

    public /* synthetic */ TriangleBlock(ColorConstraint colorConstraint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
            colorConstraint = (ColorConstraint)UtilitiesKt.toConstraint((Color)color);
        }
        this(colorConstraint);
    }

    public TriangleBlock(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this((ColorConstraint)UtilitiesKt.toConstraint((Color)color));
    }

    public TriangleBlock(@NotNull State<Color> color) {
        Intrinsics.checkNotNullParameter(color, (String)"color");
        this((ColorConstraint)ExtensionsKt.toConstraint(color));
    }

    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width = this.getRight();
        double height = this.getBottom();
        this.drawTriangle(matrixStack, x, y, width, height);
        super.draw(matrixStack);
    }

    public final void drawTriangle(@NotNull UMatrixStack matrixStack, double x, double y, double w, double h) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            return;
        }
        this.drawTriangle(matrixStack, x, y, w, h, color);
    }

    public final void drawTriangle(@NotNull UMatrixStack matrixStack, double x, double y, double w, double h, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        UGraphics.enableBlend();
        UGraphics.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        UGraphics buf = UGraphics.getFromTessellator();
        buf.beginWithDefaultShader(UGraphics.DrawMode.TRIANGLES, UGraphics.CommonVertexFormats.POSITION_COLOR);
        Intrinsics.checkNotNull((Object)buf);
        this.drawTriangle(buf, matrixStack, x, y, w, h, color);
        UGraphics.disableBlend();
    }

    public final void drawTriangle(@NotNull UGraphics tess, @NotNull UMatrixStack matrixStack, double x, double y, double w, double h, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)tess, (String)"tess");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        tess.pos(matrixStack, x, y, 0.0).color(red, green, blue, alpha).endVertex();
        tess.pos(matrixStack, w, h, 0.0).color(red, green, blue, alpha).endVertex();
        tess.pos(matrixStack, w, y, 0.0).color(red, green, blue, alpha).endVertex();
        if (ElementaVersion.Companion.isActive().compareTo((Enum)ElementaVersion.V2) >= 0) {
            UGraphics.enableDepth();
            UGraphics.depthFunc((int)519);
            tess.drawDirect();
            UGraphics.disableDepth();
            UGraphics.depthFunc((int)515);
        } else {
            tess.drawDirect();
        }
    }

    public TriangleBlock() {
        this(null, 1, null);
    }
}

