/*
 * Decompiled with CFR 0.152.
 */
package net.mcskill.shop.client.screen.component.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.MasterConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.dsl.BasicConstraintsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.font.FontProvider;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.mcskill.shop.client.screen.component.input.AbstractTextInput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001BM\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\u0006\u0010#\u001a\u00020\u0003J\b\u0010$\u001a\u00020\u001dH\u0014J\b\u0010%\u001a\u00020\u001dH\u0014J\u001c\u0010&\u001a\u00060'R\u00020\u00012\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0014J\u0014\u0010*\u001a\u00020\u001d2\n\u0010+\u001a\u00060'R\u00020\u0001H\u0014J\u0006\u0010,\u001a\u00020\u001dJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000eJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0003J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0017H\u0014J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\u0003H\u0014R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnet/mcskill/shop/client/screen/component/input/TextInput;", "Lnet/mcskill/shop/client/screen/component/input/AbstractTextInput;", "placeholder", "", "selectionBackgroundColor", "Ljava/awt/Color;", "selectionForegroundColor", "allowInactiveSelection", "", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "(Ljava/lang/String;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "maxWidth", "Lgg/essential/elementa/constraints/WidthConstraint;", "getMaxWidth", "()Lgg/essential/elementa/constraints/WidthConstraint;", "setMaxWidth", "(Lgg/essential/elementa/constraints/WidthConstraint;)V", "minWidth", "getMinWidth", "setMinWidth", "placeholderWidth", "", "getPlaceholderWidth", "()F", "validator", "Lkotlin/text/Regex;", "commitTextAddition", "", "newText", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getText", "getTextForRender", "onEnterPressed", "recalculateDimensions", "screenPosToVisualPos", "Lnet/mcskill/shop/client/screen/component/input/AbstractTextInput$LinePosition;", "x", "y", "scrollIntoView", "pos", "setCursorPos", "constraint", "setValidator", "regex", "splitTextForWrapping", "", "text", "maxLineWidth", "textToLines", "MSShop"})
public final class TextInput
extends AbstractTextInput {
    @Nullable
    private WidthConstraint minWidth;
    @Nullable
    private WidthConstraint maxWidth;
    private final float placeholderWidth;
    @Nullable
    private Regex validator;

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        super(placeholder, false, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor);
        this.placeholderWidth = UtilitiesKt.fontWidth$default((String)placeholder, (float)0.0f, (FontProvider)this.getFontProvider(), (int)1, null);
    }

    public /* synthetic */ TextInput(String string, Color color, Color color2, boolean bl, Color color3, Color color4, Color color5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            Color color6 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
            color = color6;
        }
        if ((n & 4) != 0) {
            color2 = new Color(64, 139, 229);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            color3 = new Color(176, 176, 176);
        }
        if ((n & 0x20) != 0) {
            Color color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"WHITE");
            color4 = color7;
        }
        if ((n & 0x40) != 0) {
            Color color8 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
            color5 = color8;
        }
        this(string, color, color2, bl, color3, color4, color5);
    }

    @Nullable
    protected final WidthConstraint getMinWidth() {
        return this.minWidth;
    }

    protected final void setMinWidth(@Nullable WidthConstraint widthConstraint) {
        this.minWidth = widthConstraint;
    }

    @Nullable
    protected final WidthConstraint getMaxWidth() {
        return this.maxWidth;
    }

    protected final void setMaxWidth(@Nullable WidthConstraint widthConstraint) {
        this.maxWidth = widthConstraint;
    }

    protected final float getPlaceholderWidth() {
        return this.placeholderWidth;
    }

    @NotNull
    public final TextInput setValidator(@NotNull String regex) {
        TextInput textInput;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        TextInput $this$setValidator_u24lambda_u240 = textInput = this;
        boolean bl = false;
        $this$setValidator_u24lambda_u240.validator = new Regex(regex);
        return textInput;
    }

    @NotNull
    public final TextInput setMinWidth(@NotNull WidthConstraint constraint) {
        TextInput textInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        TextInput $this$setMinWidth_u24lambda_u241 = textInput = this;
        boolean bl = false;
        $this$setMinWidth_u24lambda_u241.minWidth = constraint;
        return textInput;
    }

    @NotNull
    public final TextInput setMaxWidth(@NotNull WidthConstraint constraint) {
        TextInput textInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        TextInput $this$setMaxWidth_u24lambda_u242 = textInput = this;
        boolean bl = false;
        $this$setMaxWidth_u24lambda_u242.maxWidth = constraint;
        return textInput;
    }

    @Override
    @NotNull
    public String getText() {
        return ((AbstractTextInput.TextualLine)CollectionsKt.first(this.getTextualLines())).getText();
    }

    @NotNull
    public final String getTextForRender() {
        return this.getText();
    }

    public final void setCursorPos() {
        UIComponent.unhide$default((UIComponent)this.getCursorComponent(), (boolean)false, (int)1, null);
        float cursorPosX = ((Number)this.getCursor().toScreenPos().component1()).floatValue();
        MasterConstraint posX = cursorPosX > 0.0f && this.getCursor().isAtLineEnd() ? (MasterConstraint)ConstraintsKt.minus((SuperConstraint)((SuperConstraint)UtilitiesKt.getPixel((Number)Float.valueOf(cursorPosX))), (SuperConstraint)((SuperConstraint)UtilitiesKt.getDp((Number)1))) : (MasterConstraint)UtilitiesKt.getPixel((Number)Float.valueOf(cursorPosX));
        this.getCursorComponent().setX((XConstraint)posX);
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CollectionsKt.listOf((Object)StringsKt.replace$default((String)text, (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int column = pos.getColumn();
        String lineText = this.getTextForRender();
        if (column < 0 || column > lineText.length()) {
            return;
        }
        String string = lineText.substring(0, column);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        float widthBeforePosition = UtilitiesKt.fontWidth((String)string, (float)this.getTextScale(), (FontProvider)this.getFontProvider());
        if (UtilitiesKt.fontWidth((String)this.getTextForRender(), (float)this.getTextScale(), (FontProvider)this.getFontProvider()) < this.getWidth()) {
            this.setHorizontalScrollingOffset(0.0f);
        } else if (this.getHorizontalScrollingOffset() > widthBeforePosition) {
            this.setHorizontalScrollingOffset(widthBeforePosition);
        } else if (widthBeforePosition - this.getHorizontalScrollingOffset() > this.getWidth()) {
            this.setHorizontalScrollingOffset(widthBeforePosition - this.getWidth());
        }
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float targetXPos = x + this.getHorizontalScrollingOffset();
        float currentX = 0.0f;
        String line = this.getTextForRender();
        int n = line.length();
        for (int i2 = 0; i2 < n; ++i2) {
            float charWidth = UtilitiesKt.width((char)line.charAt(i2), (float)this.getTextScale());
            if (currentX + charWidth / (float)2 >= targetXPos) {
                return new AbstractTextInput.LinePosition(0, i2, true);
            }
            currentX += charWidth;
        }
        return new AbstractTextInput.LinePosition(0, line.length(), true);
    }

    @Override
    protected void recalculateDimensions() {
        if (this.minWidth != null && this.maxWidth != null) {
            float width = !this.hasText() && !this.getActive() ? this.placeholderWidth : UtilitiesKt.fontWidth((String)this.getTextForRender(), (float)this.getTextScale(), (FontProvider)this.getFontProvider()) + 1.0f;
            SuperConstraint superConstraint = (SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(width), (boolean)false, (boolean)false, (int)3, null);
            WidthConstraint widthConstraint = this.minWidth;
            Intrinsics.checkNotNull((Object)widthConstraint);
            SuperConstraint superConstraint2 = (SuperConstraint)widthConstraint;
            WidthConstraint widthConstraint2 = this.maxWidth;
            Intrinsics.checkNotNull((Object)widthConstraint2);
            this.setWidth((WidthConstraint)ConstraintsKt.coerceIn((SuperConstraint)superConstraint, (SuperConstraint)superConstraint2, (SuperConstraint)((SuperConstraint)widthConstraint2)));
        }
    }

    @Override
    protected void commitTextAddition(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        if (this.validator != null) {
            CharSequence charSequence = newText;
            Regex regex = this.validator;
            Intrinsics.checkNotNull((Object)regex);
            if (!regex.matches(charSequence)) {
                return;
            }
        }
        super.commitTextAddition(newText);
    }

    @Override
    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text, float maxLineWidth) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CollectionsKt.listOf((Object)text);
    }

    @Override
    protected void onEnterPressed() {
        this.getActivateAction().invoke((Object)this.getText());
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        if (!this.getActive() && !this.hasText()) {
            float textHeight = (this.getHeight() - UtilitiesKt.fontHeight((String)this.getPlaceholder(), (float)this.getTextScale(), (FontProvider)this.getFontProvider())) / (float)2;
            FontProvider.DefaultImpls.drawString$default((FontProvider)this.getFontProvider(), (UMatrixStack)matrixStack, (String)this.getPlaceholder(), (Color)this.getColor(), (float)this.getLeft(), (float)(this.getTop() + textHeight), (float)10.0f, (float)this.getTextScale(), (boolean)this.getShadow(), null, (int)256, null);
            super.draw(matrixStack);
            return;
        }
        String lineText = this.getTextForRender();
        if (this.hasSelection()) {
            float currentX = this.getLeft();
            this.getCursorComponent().hide(true);
            if (!this.selectionStart().isAtLineStart()) {
                String string = lineText.substring(0, this.selectionStart().getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String preSelectionText = string;
                this.drawUnselectedTextCompat(matrixStack, preSelectionText, currentX, 0);
                currentX += UtilitiesKt.fontWidth((String)preSelectionText, (float)this.getTextScale(), (FontProvider)this.getFontProvider());
            }
            String string = lineText.substring(this.selectionStart().getColumn(), this.selectionEnd().getColumn());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String selectedText2 = string;
            float selectedTextWidth = UtilitiesKt.fontWidth((String)selectedText2, (float)this.getTextScale(), (FontProvider)this.getFontProvider());
            this.drawSelectedTextCompat(matrixStack, selectedText2, currentX, currentX + selectedTextWidth, 0);
            currentX += selectedTextWidth;
            if (!this.selectionEnd().isAtLineEnd()) {
                String string2 = lineText.substring(this.selectionEnd().getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                this.drawUnselectedTextCompat(matrixStack, string2, currentX, 0);
            }
        } else {
            if (this.getActive()) {
                this.getCursorComponent().setY(BasicConstraintsKt.basicYConstraint((Function1)((Function1)new Function1<UIComponent, Float>(this){
                    final /* synthetic */ TextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull UIComponent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Float.valueOf(this.this$0.getTop());
                    }
                })));
                this.setCursorPos();
            }
            this.drawUnselectedTextCompat(matrixStack, lineText, this.getLeft(), 0);
        }
        super.draw(matrixStack);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        this(placeholder, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 64, null);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        this(placeholder, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 96, null);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 112, null);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 120, null);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        this(placeholder, selectionBackgroundColor, null, false, null, null, null, 124, null);
    }

    @JvmOverloads
    public TextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, null, null, false, null, null, null, 126, null);
    }

    @JvmOverloads
    public TextInput() {
        this(null, null, null, false, null, null, null, 127, null);
    }
}

