/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.world.level.block;

import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MagnumTorchBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TORCH_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final Type type;

    public MagnumTorchBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return TORCH_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return MagnumTorchBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 1.125;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, level, tooltip, tooltipFlag);
        tooltip.add((Component)Component.m_237115_((String)"block.magnumtorch.magnum_torch.info").m_130940_(ChatFormatting.GRAY));
        if (level != null) {
            if (!Proxy.INSTANCE.hasShiftDown()) {
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.more", (Object[])new Object[]{Component.m_237115_((String)"block.magnumtorch.magnum_torch.info.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
            } else if (MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
                ServerConfig.MagnumTorchConfig config = this.type.getConfig();
                if (!config.mobCategories.isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.mob_types", (Object[])new Object[]{MagnumTorchBlock.mergeComponentList(config.mobCategories, ChatFormatting.YELLOW, Enum::name)}).m_130940_(ChatFormatting.GRAY));
                }
                if (!config.mobBlacklist.isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.blacklist", (Object[])new Object[]{MagnumTorchBlock.mergeComponentList(config.mobBlacklist, ChatFormatting.AQUA, value -> BuiltInRegistries.f_256780_.m_7981_(value).toString())}).m_130940_(ChatFormatting.GRAY));
                }
                if (!config.mobWhitelist.isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.whitelist", (Object[])new Object[]{MagnumTorchBlock.mergeComponentList(config.mobWhitelist, ChatFormatting.AQUA, value -> BuiltInRegistries.f_256780_.m_7981_(value).toString())}).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.shape_type", (Object[])new Object[]{Component.m_237113_((String)config.shapeType.name()).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.horizontal_range", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(config.horizontalRange)).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"block.magnumtorch.magnum_torch.info.vertical_range", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(config.verticalRange)).m_130940_(ChatFormatting.LIGHT_PURPLE)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    private static <T> Component mergeComponentList(Collection<? extends T> collection, ChatFormatting format, Function<T, String> keyExtractor) {
        return (Component)collection.stream().map(mob -> Component.m_237113_((String)((String)keyExtractor.apply(mob))).m_130940_(format)).reduce((o1, o2) -> o1.m_130946_(", ").m_7220_((Component)o2)).orElse(Component.m_237119_());
    }

    public static enum Type implements StringRepresentable
    {
        DIAMOND("diamond_magnum_torch", () -> ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).diamond),
        EMERALD("emerald_magnum_torch", () -> ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).emerald),
        AMETHYST("amethyst_magnum_torch", () -> ((ServerConfig)MagnumTorch.CONFIG.get(ServerConfig.class)).amethyst);

        private final String name;
        private final Supplier<ServerConfig.MagnumTorchConfig> config;

        private Type(String name, Supplier<ServerConfig.MagnumTorchConfig> config) {
            this.name = name;
            this.config = config;
        }

        public ServerConfig.MagnumTorchConfig getConfig() {
            return this.config.get();
        }

        public ResourceKey<PoiType> getPoiTypeKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)MagnumTorch.id(this.name));
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

