/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.fluid.TextureFluidType;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.registration.DelayedSupplier;
import slimeknights.mantle.registration.FluidBuilder;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;

public class FluidDeferredRegister
extends DeferredRegisterWrapper<Fluid> {
    private final SynchronizedDeferredRegister<FluidType> fluidTypeRegister;
    private final SynchronizedDeferredRegister<Block> blockRegister;
    private final SynchronizedDeferredRegister<Item> itemRegister;

    public FluidDeferredRegister(String modID) {
        super(Registries.f_256808_, modID);
        this.fluidTypeRegister = SynchronizedDeferredRegister.create(ForgeRegistries.Keys.FLUID_TYPES, modID);
        this.blockRegister = SynchronizedDeferredRegister.create(Registries.f_256747_, modID);
        this.itemRegister = SynchronizedDeferredRegister.create(Registries.f_256913_, modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.fluidTypeRegister.register(bus);
        this.blockRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public <I extends FluidType> RegistryObject<I> registerType(String name, Supplier<? extends I> sup) {
        return this.fluidTypeRegister.register(name, sup);
    }

    public <I extends Fluid> RegistryObject<I> registerFluid(String name, Supplier<? extends I> sup) {
        return this.register.register(name, sup);
    }

    public Builder register(String name) {
        return new Builder(name);
    }

    public static BlockBehaviour.Properties createProperties(MapColor color, int lightLevel) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280170_().m_60910_().m_60977_().m_60978_(100.0f).m_60953_(state -> lightLevel).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_);
    }

    public class Builder
    extends FluidBuilder<Builder> {
        private final String name;
        private final DelayedSupplier<Fluid> stillDelayed = new DelayedSupplier();
        @Nullable
        private String commonTag = null;

        private Builder(String name) {
            this.name = name;
        }

        public Builder commonTag() {
            return this.commonTag(this.name);
        }

        public Builder type(Supplier<? extends FluidType> type) {
            if (this.type != null) {
                throw new IllegalStateException("Type already created for " + this.name);
            }
            this.type = FluidDeferredRegister.this.fluidTypeRegister.register(this.name, type);
            return this;
        }

        public Builder type(FluidType.Properties properties) {
            return this.type(() -> new TextureFluidType(properties));
        }

        public Builder type() {
            return this.type(FluidType.Properties.create());
        }

        public Builder bucket(Function<Supplier<? extends Fluid>, Item> constructor) {
            if (this.bucket != null) {
                throw new IllegalStateException("Bucket already created for " + this.name);
            }
            return (Builder)this.bucket((Supplier<? extends Item>)FluidDeferredRegister.this.itemRegister.register(this.name + "_bucket", () -> (Item)constructor.apply(this.stillDelayed)));
        }

        public Builder bucket() {
            return (Builder)this.bucket((Supplier<? extends Item>)FluidDeferredRegister.this.itemRegister.register(this.name + "_bucket", () -> new BucketItem(this.stillDelayed, RegistrationHelper.BUCKET_PROPS)));
        }

        public Builder block(Function<Supplier<? extends FlowingFluid>, LiquidBlock> constructor) {
            if (this.block != null) {
                throw new IllegalStateException("Block already created for " + this.name);
            }
            return (Builder)this.block((Supplier<? extends LiquidBlock>)FluidDeferredRegister.this.blockRegister.register(this.name + "_fluid", () -> (LiquidBlock)constructor.apply(this.stillDelayed)));
        }

        public Builder block(MapColor color, int lightLevel) {
            return this.block((Supplier<? extends FlowingFluid> sup) -> new LiquidBlock(sup, FluidDeferredRegister.createProperties(color, lightLevel)));
        }

        public FluidObject<UnplaceableFluid> unplacable() {
            return this.unplacable(UnplaceableFluid::new);
        }

        public <F extends Fluid> FluidObject<F> unplacable(Function<FluidBuilder<?>, F> constructor) {
            if (this.block != null) {
                throw new IllegalStateException("Cannot build an unplacable fluid with a block form");
            }
            if (this.type == null) {
                this.type();
            }
            RegistryObject<Fluid> fluid = FluidDeferredRegister.this.registerFluid(this.name, () -> (Fluid)constructor.apply(this));
            this.stillDelayed.setSupplier((Supplier<Fluid>)fluid);
            return new FluidObject<Fluid>(FluidDeferredRegister.this.resource(this.name), this.commonTag, (Supplier<FluidType>)((Supplier<? extends FluidType>)this.type), (Supplier<Fluid>)fluid);
        }

        public FlowingFluidObject<ForgeFlowingFluid> flowing() {
            return this.flowing(ForgeFlowingFluid.Source::new, ForgeFlowingFluid.Flowing::new);
        }

        public <F extends FlowingFluid> FlowingFluidObject<F> flowing(Function<ForgeFlowingFluid.Properties, ? extends F> createStill, Function<ForgeFlowingFluid.Properties, ? extends F> createFlowing) {
            if (this.type == null) {
                this.type();
            }
            DelayedSupplier<FlowingFluid> flowingDelayed = new DelayedSupplier<FlowingFluid>();
            ForgeFlowingFluid.Properties props = this.build(this.type, this.stillDelayed, flowingDelayed);
            RegistryObject<FlowingFluid> still = FluidDeferredRegister.this.registerFluid(this.name, () -> (FlowingFluid)createStill.apply(props));
            this.stillDelayed.setSupplier((Supplier<Fluid>)still);
            RegistryObject<FlowingFluid> flowing = FluidDeferredRegister.this.registerFluid("flowing_" + this.name, () -> (FlowingFluid)createFlowing.apply(props));
            flowingDelayed.setSupplier((Supplier<FlowingFluid>)flowing);
            return new FlowingFluidObject<FlowingFluid>(FluidDeferredRegister.this.resource(this.name), this.commonTag, (Supplier<FluidType>)((Supplier<? extends FluidType>)this.type), (Supplier<FlowingFluid>)still, (Supplier<FlowingFluid>)flowing, (Supplier<LiquidBlock>)((Supplier<? extends LiquidBlock>)this.block));
        }

        public Builder commonTag(@Nullable String commonTag) {
            this.commonTag = commonTag;
            return this;
        }
    }
}

