/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ru.auriny.omegatalents.network.PacketHandler;
import ru.auriny.omegatalents.network.RequestPlayerDataPacket;

public class ClientPlayerDataManager {
    private static final Map<UUID, Map<String, Integer>> playerDataCache = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private static final Map<UUID, Long> requestedPlayers = new ConcurrentHashMap<UUID, Long>();

    public static void updatePlayerData(UUID playerUUID, Map<String, Integer> data) {
        playerDataCache.put(playerUUID, data);
    }

    public static int getPlayerTotalLevel(UUID playerUUID) {
        Map<String, Integer> data = playerDataCache.get(playerUUID);
        if (data != null) {
            return data.values().stream().mapToInt(Integer::intValue).sum();
        }
        ClientPlayerDataManager.requestPlayerData(playerUUID);
        return 0;
    }

    private static void requestPlayerData(UUID playerUUID) {
        long now = System.currentTimeMillis();
        if (!requestedPlayers.containsKey(playerUUID) || now - requestedPlayers.get(playerUUID) > 5000L) {
            requestedPlayers.put(playerUUID, now);
            PacketHandler.sendToServer(new RequestPlayerDataPacket(playerUUID));
        }
    }
}

