/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.client.gui;

import divinerpg.registries.AttributesRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import ru.auriny.omegatalents.client.ClientData;
import ru.auriny.omegatalents.network.PacketHandler;
import ru.auriny.omegatalents.network.RequestDamagePacket;
import ru.auriny.omegatalents.network.RequestPlayerDataPacket;
import ru.auriny.omegatalents.network.UpgradePacket;
import ru.auriny.omegatalents.registries.OTAttributeRegistry;
import ru.auriny.omegatalents.utils.PlayerUpgradeData;
import ru.auriny.omegatalents.utils.UpgradeType;

public class UpgradeScreen
extends Screen {
    private static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("omegatalents", "textures/gui/logo.png");
    int leftPos;
    int topPos;
    private int guiWidth;
    private int guiHeight;
    private int leftPanelWidth;
    private int rightPanelWidth;
    private final Map<UpgradeType, UpgradeButton> upgradeButtons = new HashMap<UpgradeType, UpgradeButton>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private int scrollContentHeight = 0;
    private int statsScrollOffset = 0;
    private int maxStatsScrollOffset = 0;
    private boolean isDraggingLeftScroll = false;
    private boolean isDraggingRightScroll = false;
    private double dragStartMouseY;
    private int dragStartScrollOffset;

    public UpgradeScreen(Component title) {
        super(title);
    }

    protected void m_7856_() {
        super.m_7856_();
        int imageWidth = 420;
        this.leftPos = (this.f_96543_ - imageWidth) / 2;
        int imageHeight = 260;
        this.topPos = (this.f_96544_ - imageHeight) / 2;
        PacketHandler.sendToServer(new RequestPlayerDataPacket());
        PacketHandler.sendToServer(new RequestDamagePacket());
        this.guiWidth = imageWidth;
        this.guiHeight = imageHeight;
        this.leftPanelWidth = (int)((float)this.guiWidth * 0.55f);
        this.rightPanelWidth = this.guiWidth - this.leftPanelWidth;
        int buttonWidth = this.leftPanelWidth - 40;
        int buttonHeight = 55;
        int startY = this.topPos + 50;
        int buttonGapY = 12;
        this.scrollContentHeight = UpgradeType.values().length * (buttonHeight + buttonGapY) - buttonGapY;
        int visibleAreaHeight = this.guiHeight - 50 - 20;
        this.maxScrollOffset = Math.max(0, this.scrollContentHeight - visibleAreaHeight);
        int index = 0;
        for (UpgradeType type : UpgradeType.values()) {
            int x = this.leftPos + 20;
            int y = startY + index * (buttonHeight + buttonGapY);
            UpgradeButton button = new UpgradeButton(x, y, buttonWidth, buttonHeight, type, this::onUpgradeClick);
            this.upgradeButtons.put(type, button);
            ++index;
        }
    }

    private void onUpgradeClick(UpgradeType type) {
        if (this.f_96541_ != null && PlayerUpgradeData.canUpgrade((Player)this.f_96541_.f_91074_, type)) {
            PacketHandler.sendToServer(new UpgradePacket(type));
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (mouseX >= (double)this.leftPos && mouseX <= (double)(this.leftPos + this.leftPanelWidth)) {
            this.scrollOffset = (int)((double)this.scrollOffset - scrollDelta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
            return true;
        }
        if (mouseX >= (double)(this.leftPos + this.leftPanelWidth) && mouseX <= (double)(this.leftPos + this.guiWidth)) {
            this.statsScrollOffset = (int)((double)this.statsScrollOffset - scrollDelta * 10.0);
            this.statsScrollOffset = Math.max(0, Math.min(this.statsScrollOffset, this.maxStatsScrollOffset));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int[] rightScrollbarBounds;
        int[] rightHandleBounds;
        int[] leftScrollbarBounds;
        int[] leftHandleBounds;
        if (this.maxScrollOffset > 0 && mouseX >= (double)(leftHandleBounds = this.getScrollHandleBounds(leftScrollbarBounds = this.getScrollbarBounds(this.leftPanelWidth), this.guiHeight - 60, this.scrollContentHeight, this.scrollOffset, this.maxScrollOffset))[0] && mouseX <= (double)(leftHandleBounds[0] + leftHandleBounds[2]) && mouseY >= (double)leftHandleBounds[1] && mouseY <= (double)(leftHandleBounds[1] + leftHandleBounds[3])) {
            this.isDraggingLeftScroll = true;
            this.dragStartMouseY = mouseY;
            this.dragStartScrollOffset = this.scrollOffset;
            return true;
        }
        int rightScrollAreaHeight = this.guiHeight - 60;
        int totalStatsHeight = this.calculateStatsHeight();
        int currentMaxStatsScroll = Math.max(0, totalStatsHeight - rightScrollAreaHeight);
        if (currentMaxStatsScroll > 0 && mouseX >= (double)(rightHandleBounds = this.getScrollHandleBounds(rightScrollbarBounds = this.getScrollbarBounds(this.guiWidth), rightScrollAreaHeight, totalStatsHeight, this.statsScrollOffset, currentMaxStatsScroll))[0] && mouseX <= (double)(rightHandleBounds[0] + rightHandleBounds[2]) && mouseY >= (double)rightHandleBounds[1] && mouseY <= (double)(rightHandleBounds[1] + rightHandleBounds[3])) {
            this.isDraggingRightScroll = true;
            this.dragStartMouseY = mouseY;
            this.dragStartScrollOffset = this.statsScrollOffset;
            return true;
        }
        int leftScrollAreaX = this.leftPos + 10;
        int leftScrollAreaY = this.topPos + 40;
        int leftScrollAreaWidth = this.leftPanelWidth - 20;
        int leftScrollAreaHeight = this.guiHeight - 60;
        if (mouseX >= (double)leftScrollAreaX && mouseX <= (double)(leftScrollAreaX + leftScrollAreaWidth) && mouseY >= (double)leftScrollAreaY && mouseY <= (double)(leftScrollAreaY + leftScrollAreaHeight)) {
            for (UpgradeButton upgradeButton : this.upgradeButtons.values()) {
                int visibleY = upgradeButton.m_252907_() - this.scrollOffset;
                if (!(mouseX >= (double)upgradeButton.m_252754_()) || !(mouseX <= (double)(upgradeButton.m_252754_() + upgradeButton.m_5711_())) || !(mouseY >= (double)visibleY) || !(mouseY <= (double)(visibleY + upgradeButton.m_93694_()))) continue;
                int originalY = upgradeButton.m_252907_();
                upgradeButton.m_253211_(visibleY);
                boolean clicked = upgradeButton.m_6375_(mouseX, mouseY, button);
                upgradeButton.m_253211_(originalY);
                if (!clicked) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingLeftScroll) {
            int scrollBarHeight = this.guiHeight - 60;
            double deltaY = mouseY - this.dragStartMouseY;
            double scrollRatio = (double)this.maxScrollOffset / (double)(scrollBarHeight - this.getScrollHandleBounds(this.getScrollbarBounds(this.leftPanelWidth), this.guiHeight - 60, this.scrollContentHeight, this.scrollOffset, this.maxScrollOffset)[3]);
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScrollOffset, (double)this.dragStartScrollOffset + deltaY * scrollRatio));
            return true;
        }
        if (this.isDraggingRightScroll) {
            int rightScrollAreaHeight = this.guiHeight - 60;
            int totalStatsHeight = this.calculateStatsHeight();
            int currentMaxStatsScroll = Math.max(0, totalStatsHeight - rightScrollAreaHeight);
            int scrollBarHeight = this.guiHeight - 60;
            double deltaY = mouseY - this.dragStartMouseY;
            double scrollRatio = (double)currentMaxStatsScroll / (double)(scrollBarHeight - this.getScrollHandleBounds(this.getScrollbarBounds(this.guiWidth), rightScrollAreaHeight, totalStatsHeight, this.statsScrollOffset, currentMaxStatsScroll)[3]);
            this.statsScrollOffset = (int)Math.max(0.0, Math.min((double)currentMaxStatsScroll, (double)this.dragStartScrollOffset + deltaY * scrollRatio));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isDraggingLeftScroll = false;
        this.isDraggingRightScroll = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void renderStatLine(GuiGraphics graphics, int x, int y, int width, int height, String label, String value, int labelColor) {
        int startColor = 0x661A1A1A;
        int endColor = 0x66000000;
        this.drawRoundedRectWithGradient(graphics, x, y, width, height, 4, startColor, endColor);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, label, x + 8, y + (height - 9) / 2, labelColor, false);
        int valueWidth = this.f_96547_.m_92895_(value);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280056_(this.f_96547_, value, x + width - 8 - valueWidth, y + (height - 9) / 2, -1, false);
    }

    private int calculateStatsHeight() {
        int lineHeight = 16;
        int titlePadding = 8;
        int statBoxHeight = 22;
        int lineGap = 4;
        int statsLinesCount = 8;
        int totalHeight = lineHeight + titlePadding + statsLinesCount * (statBoxHeight + lineGap);
        return totalHeight - lineGap;
    }

    private void renderTitle(GuiGraphics graphics) {
        int infoX = this.leftPos + this.leftPanelWidth + 21;
        int infoY = this.topPos + 21;
        LocalPlayer player = this.f_96541_.f_91074_;
        assert (player != null);
        MutableComponent playerTitle = Component.m_237113_((String)("\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 " + player.m_7755_().getString())).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        graphics.m_280614_(this.f_96547_, (Component)playerTitle, infoX, infoY, -1, false);
    }

    private void renderPlayerInfo(GuiGraphics graphics, int scrollOffset) {
        int infoX = this.leftPos + this.leftPanelWidth + 21;
        int infoY = this.topPos + 21;
        int lineHeight = 16;
        int lineGap = 4;
        int linePadding = 10;
        int statBoxWidth = this.rightPanelWidth - 50;
        int statBoxHeight = 22;
        LocalPlayer player = this.f_96541_.f_91074_;
        assert (player != null);
        String levelValue = String.valueOf(PlayerUpgradeData.getTotalLevel((Player)player));
        this.renderStatLine(graphics, infoX - linePadding, infoY += lineHeight + 8 - scrollOffset, statBoxWidth, statBoxHeight, "\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u043f\u0440\u043e\u043a\u0430\u0447\u043a\u0438", levelValue, -1671646);
        String damageValue = String.format("%.1f", ClientData.lastDamage);
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0423\u0440\u043e\u043d", damageValue, 13579573);
        String critChanceValue = String.format("%.1f", player.m_21133_((Attribute)OTAttributeRegistry.CRITICAL_CHANCE.get())) + "%";
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0428\u0430\u043d\u0441 \u043a\u0440\u0438\u0442\u0430", critChanceValue, 14268263);
        String healthValue = String.format("%.0f", Float.valueOf(player.m_21233_()));
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u041c\u0430\u043a\u0441. \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u0435", healthValue, -1618884);
        String regenerationValue = String.format("%.0f", player.m_21133_((Attribute)OTAttributeRegistry.REGENERATION.get()) * 100.0) + "%";
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f", regenerationValue, 15486557);
        String armorValue = String.format("%.1f", player.m_21133_((Attribute)AttributeRegistry.PERCENT_ARMOR.get())) + "%";
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0411\u0440\u043e\u043d\u044f", armorValue, -13330213);
        String speedValue = String.format("%.1f", Float.valueOf(player.m_6113_() * 100.0f));
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c", speedValue, -13710223);
        String arcanaValue = String.format("%.0f", player.m_21133_((Attribute)AttributesRegistry.ARCANA_MAX.get()));
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u041c\u0430\u043a\u0441. \u0410\u0440\u043a\u0430\u043d\u0430", arcanaValue, 7833311);
        String regenArcanaValue = String.format("%.0f", player.m_21133_((Attribute)AttributesRegistry.ARCANA_REGEN.get()) * 100.0) + "%";
        this.renderStatLine(graphics, infoX - linePadding, infoY += statBoxHeight + lineGap, statBoxWidth, statBoxHeight, "\u0420\u0435\u0433\u0435\u043d. \u0410\u0440\u043a\u0430\u043d\u044b", regenArcanaValue, 9088241);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int x = this.leftPos;
        int y = this.topPos;
        this.drawRoundedRectWithGradient(graphics, x, y, this.guiWidth - 2, this.guiHeight - 2, 11, 0x71000000, -1862270976);
        this.drawGlowingLine(graphics, x + this.leftPanelWidth - 1, y + 20, 2, this.guiHeight - 40, -10637854);
        graphics.m_280163_(LOGO_TEXTURE, this.leftPos + 12, this.topPos + 10, 0.0f, 0.0f, 201, 25, 201, 25);
        int leftScrollAreaX = this.leftPos + 10;
        int leftScrollAreaY = this.topPos + 40;
        int leftScrollAreaWidth = this.leftPanelWidth - 20;
        int leftScrollAreaHeight = this.guiHeight - 60;
        graphics.m_280588_(leftScrollAreaX, leftScrollAreaY, leftScrollAreaX + leftScrollAreaWidth, leftScrollAreaY + leftScrollAreaHeight);
        for (UpgradeButton button : this.upgradeButtons.values()) {
            int originalY = button.m_252907_();
            button.m_253211_(originalY - this.scrollOffset);
            button.m_88315_(graphics, mouseX, mouseY, partialTick);
            button.m_253211_(originalY);
        }
        graphics.m_280618_();
        this.renderTitle(graphics);
        int rightScrollAreaX = this.leftPos + this.leftPanelWidth + 10;
        int rightScrollAreaY = this.topPos + 40;
        int rightScrollAreaWidth = this.rightPanelWidth - 20;
        int rightScrollAreaHeight = this.guiHeight - 60;
        graphics.m_280588_(rightScrollAreaX, rightScrollAreaY, rightScrollAreaX + rightScrollAreaWidth, rightScrollAreaY + rightScrollAreaHeight);
        int totalStatsHeight = this.calculateStatsHeight();
        this.maxStatsScrollOffset = Math.max(0, totalStatsHeight - rightScrollAreaHeight);
        this.renderPlayerInfo(graphics, this.statsScrollOffset);
        graphics.m_280618_();
        this.drawScroll(graphics, leftScrollAreaHeight, this.maxScrollOffset, this.leftPanelWidth, this.scrollContentHeight, this.scrollOffset);
        this.drawScroll(graphics, rightScrollAreaHeight, this.maxStatsScrollOffset, this.guiWidth, totalStatsHeight, this.statsScrollOffset);
        if (mouseX >= leftScrollAreaX && mouseX <= leftScrollAreaX + leftScrollAreaWidth && mouseY >= leftScrollAreaY && mouseY <= leftScrollAreaY + leftScrollAreaHeight) {
            for (UpgradeButton button : this.upgradeButtons.values()) {
                int buttonYWithScroll = button.m_252907_() - this.scrollOffset;
                if (mouseX < button.m_252754_() || mouseX > button.m_252754_() + button.m_5711_() || mouseY < buttonYWithScroll || mouseY > buttonYWithScroll + button.m_93694_()) continue;
                this.renderUpgradeTooltip(graphics, button, mouseX, mouseY);
                break;
            }
        }
    }

    private int[] getScrollbarBounds(int panelXEnd) {
        int SCROLL_BAR_WIDTH = 6;
        int scrollBarX = this.leftPos + panelXEnd - 6 - 8;
        int scrollBarY = this.topPos + 40;
        int scrollBarHeight = this.guiHeight - 60;
        return new int[]{scrollBarX, scrollBarY, 6, scrollBarHeight};
    }

    private int[] getScrollHandleBounds(int[] scrollbarBounds, float visibleAreaHeight, float contentHeight, float currentScroll, int maxScroll) {
        float scrollbarRatio = visibleAreaHeight / contentHeight;
        int handleHeight = (int)(scrollbarRatio * (float)scrollbarBounds[3]);
        handleHeight = Math.max(10, handleHeight);
        int handleY = scrollbarBounds[1] + (int)(currentScroll / (float)maxScroll * (float)(scrollbarBounds[3] - handleHeight));
        return new int[]{scrollbarBounds[0], handleY, scrollbarBounds[2], handleHeight};
    }

    private void drawScroll(GuiGraphics graphics, float visibleAreaHeight, int maxScrollOffset, int panelXEnd, float scrollContentHeight, float scrollOffset) {
        if (maxScrollOffset > 0) {
            int[] scrollbarBounds = this.getScrollbarBounds(panelXEnd);
            graphics.m_280509_(scrollbarBounds[0], scrollbarBounds[1], scrollbarBounds[0] + scrollbarBounds[2], scrollbarBounds[1] + scrollbarBounds[3], 0x44FFFFFF);
            int[] handleBounds = this.getScrollHandleBounds(scrollbarBounds, visibleAreaHeight, scrollContentHeight, scrollOffset, maxScrollOffset);
            graphics.m_280509_(handleBounds[0] + 1, handleBounds[1], handleBounds[0] + handleBounds[2] - 1, handleBounds[1] + handleBounds[3], -1);
        }
    }

    private void renderUpgradeTooltip(GuiGraphics graphics, UpgradeButton button, int mouseX, int mouseY) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        UpgradeType type = button.getUpgradeType();
        LocalPlayer player = this.f_96541_.f_91074_;
        int currentLevel = PlayerUpgradeData.getUpgradeLevel((Player)player, type);
        int maxLevel = PlayerUpgradeData.getMaxLevel(type);
        tooltip.add(Component.m_237113_((String)type.getDisplayName()).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        tooltip.add(Component.m_237113_((String)type.getDescription()).m_130940_(ChatFormatting.GRAY));
        tooltip.add(Component.m_237113_((String)""));
        tooltip.add(Component.m_237113_((String)("\u0423\u0440\u043e\u0432\u0435\u043d\u044c: " + currentLevel + "/" + maxLevel)).m_130940_(currentLevel == maxLevel ? ChatFormatting.GREEN : ChatFormatting.WHITE));
        if (currentLevel < maxLevel) {
            boolean canAfford = PlayerUpgradeData.canUpgrade((Player)player, type);
            int requiredLevels = PlayerUpgradeData.getRequiredLevelCost(type, currentLevel + 1);
            tooltip.add(Component.m_237113_((String)("\u0426\u0435\u043d\u0430: " + requiredLevels + " \u0443\u0440\u043e\u0432\u043d\u0435\u0439")).m_130940_(canAfford ? ChatFormatting.GREEN : ChatFormatting.RED));
            if (canAfford) {
                tooltip.add(Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u043b\u0443\u0447\u0448\u0438\u0442\u044c!").m_130940_(ChatFormatting.AQUA));
            }
        } else {
            tooltip.add(Component.m_237113_((String)"\u041c\u0410\u041a\u0421\u0418\u041c\u0423\u041c").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        }
        graphics.m_280666_(this.f_96547_, tooltip, mouseX, mouseY);
    }

    private static void drawRoundedRect(GuiGraphics graphics, int x, int y, int width, int height, int radius, int color) {
        graphics.m_280509_(x + radius, y, x + width - radius, y + height, color);
        graphics.m_280509_(x, y + radius, x + width, y + height - radius, color);
        UpgradeScreen.drawQuarterCircle(graphics, x + radius, y + radius, radius, Corner.TOP_LEFT, color);
        UpgradeScreen.drawQuarterCircle(graphics, x + width - radius, y + radius, radius, Corner.TOP_RIGHT, color);
        UpgradeScreen.drawQuarterCircle(graphics, x + radius, y + height - radius, radius, Corner.BOTTOM_LEFT, color);
        UpgradeScreen.drawQuarterCircle(graphics, x + width - radius, y + height - radius, radius, Corner.BOTTOM_RIGHT, color);
    }

    private void drawRoundedRectWithGradient(GuiGraphics graphics, int x, int y, int width, int height, int radius, int startColor, int endColor) {
        graphics.m_280024_(x, y + radius, x + width, y + height - radius, startColor, endColor);
        graphics.m_280509_(x + radius, y, x + width - radius, y + radius, startColor);
        graphics.m_280509_(x + radius, y + height - radius, x + width - radius, y + height, endColor);
        UpgradeScreen.drawQuarterCircle(graphics, x + radius, y + radius, radius, Corner.TOP_LEFT, startColor);
        UpgradeScreen.drawQuarterCircle(graphics, x + width - radius, y + radius, radius, Corner.TOP_RIGHT, startColor);
        UpgradeScreen.drawQuarterCircle(graphics, x + radius, y + height - radius, radius, Corner.BOTTOM_LEFT, endColor);
        UpgradeScreen.drawQuarterCircle(graphics, x + width - radius, y + height - radius, radius, Corner.BOTTOM_RIGHT, endColor);
    }

    private void drawGlowingLine(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x, y, x + width, y + height, color);
        int glowColor = color & 0xFFFFFF | 0x33000000;
        graphics.m_280509_(x - 1, y, x, y + height, glowColor);
        graphics.m_280509_(x + width, y, x + width + 1, y + height, glowColor);
    }

    private static void drawQuarterCircle(GuiGraphics graphics, int centerX, int centerY, int radius, Corner corner, int color) {
        UpgradeScreen.draw(graphics, centerX, centerY, radius, color, corner == Corner.TOP_LEFT, corner == Corner.TOP_RIGHT, corner == Corner.BOTTOM_LEFT, corner == Corner.BOTTOM_RIGHT);
    }

    private static void draw(GuiGraphics graphics, int centerX, int centerY, int radius, int color, boolean b, boolean b2, boolean b3, boolean b4) {
        for (int i = 0; i <= radius; ++i) {
            int halfWidth = (int)Math.sqrt(radius * radius - i * i);
            if (b) {
                graphics.m_280509_(centerX - halfWidth, centerY - i, centerX, centerY - i + 1, color);
                continue;
            }
            if (b2) {
                graphics.m_280509_(centerX, centerY - i, centerX + halfWidth, centerY - i + 1, color);
                continue;
            }
            if (b3) {
                graphics.m_280509_(centerX - halfWidth, centerY + i, centerX, centerY + i + 1, color);
                continue;
            }
            if (!b4) continue;
            graphics.m_280509_(centerX, centerY + i, centerX + halfWidth, centerY + i + 1, color);
        }
    }

    private static class UpgradeButton
    extends Button {
        private final UpgradeType upgradeType;

        public UpgradeButton(int x, int y, int width, int height, UpgradeType upgradeType, Consumer<UpgradeType> onPress) {
            super(x, y, width, height, (Component)Component.m_237113_((String)upgradeType.getDisplayName()), btn -> onPress.accept(upgradeType), f_252438_);
            this.upgradeType = upgradeType;
        }

        public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            String statusText;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            int currentLevel = PlayerUpgradeData.getUpgradeLevel((Player)player, this.upgradeType);
            int maxLevel = PlayerUpgradeData.getMaxLevel(this.upgradeType);
            boolean canUpgrade = PlayerUpgradeData.canUpgrade((Player)player, this.upgradeType);
            boolean isMaxed = currentLevel >= maxLevel;
            boolean isHovered = this.m_198029_();
            int baseColor1 = -14013910;
            int baseColor2 = -15066598;
            int borderColor = isMaxed ? -10637854 : (canUpgrade ? (isHovered ? -10637854 : 0x66FFFFFF) : 0x66FFFFFF);
            UpgradeScreen.drawRoundedRect(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 6, borderColor);
            this.fillRoundedGradient(graphics, this.m_252754_() + 1, this.m_252907_() + 1, this.f_93618_ - 2, this.f_93619_ - 2, 5, baseColor1, baseColor2);
            int leftTextColor = isMaxed ? -3355444 : -1;
            int shadowColor = -2013265920;
            String leftText = this.upgradeType.getIcon() + " " + this.upgradeType.getDisplayName();
            int leftX = this.m_252754_() + 12;
            int textY = this.m_252907_() + 12;
            graphics.m_280056_(mc.f_91062_, leftText, leftX + 1, textY + 1, shadowColor, false);
            graphics.m_280056_(mc.f_91062_, leftText, leftX, textY, leftTextColor, false);
            String rightText = currentLevel + "/" + maxLevel;
            int rightTextWidth = mc.f_91062_.m_92895_(rightText);
            int rightX = this.m_252754_() + this.f_93618_ - rightTextWidth - 12;
            int rightTextColor = -6710887;
            graphics.m_280056_(mc.f_91062_, rightText, rightX + 1, textY + 1, shadowColor, false);
            graphics.m_280056_(mc.f_91062_, rightText, rightX, textY, rightTextColor, false);
            String string = isMaxed ? "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c" : (statusText = canUpgrade ? "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e" : "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043e\u043f\u044b\u0442\u0430");
            int statusColor = isMaxed ? -14176672 : (canUpgrade ? -13330213 : -1618884);
            graphics.m_280056_(mc.f_91062_, statusText, leftX, textY + 12, statusColor, false);
            this.drawProgressBar(graphics, this.m_252754_() + 8, this.m_252907_() + this.f_93619_ - 12, this.f_93618_ - 16, 4, currentLevel, maxLevel);
        }

        private void fillRoundedGradient(GuiGraphics graphics, int x, int y, int width, int height, int radius, int startColor, int endColor) {
            graphics.m_280024_(x, y + radius, x + width, y + height - radius, startColor, endColor);
            graphics.m_280509_(x + radius, y, x + width - radius, y + radius, startColor);
            graphics.m_280509_(x + radius, y + height - radius, x + width - radius, y + height, endColor);
            this.drawQuarterCircle(graphics, x + radius, y + radius, radius, Corner.TOP_LEFT, startColor);
            this.drawQuarterCircle(graphics, x + width - radius, y + radius, radius, Corner.TOP_RIGHT, startColor);
            this.drawQuarterCircle(graphics, x + radius, y + height - radius, radius, Corner.BOTTOM_LEFT, endColor);
            this.drawQuarterCircle(graphics, x + width - radius, y + height - radius, radius, Corner.BOTTOM_RIGHT, endColor);
        }

        private void drawProgressBar(GuiGraphics graphics, int x, int y, int width, int height, int current, int max) {
            graphics.m_280509_(x, y, x + width, y + height, -15066598);
            if (current > 0 && max > 0) {
                int fillWidth = Math.max(1, (int)((float)current / (float)max * (float)width));
                int progressStart = -10637854;
                int progressEnd = -13330213;
                if (current == max) {
                    progressStart = -13710223;
                    progressEnd = -14176672;
                }
                graphics.m_280024_(x, y, x + fillWidth, y + height, progressStart, progressEnd);
            }
            graphics.m_280509_(x - 1, y - 1, x + width + 1, y, 0x66000000);
            graphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, 0x66000000);
            graphics.m_280509_(x - 1, y - 1, x, y + height + 1, 0x66000000);
            graphics.m_280509_(x + width, y - 1, x + width + 1, y + height + 1, 0x66000000);
        }

        public UpgradeType getUpgradeType() {
            return this.upgradeType;
        }

        private void drawQuarterCircle(GuiGraphics graphics, int centerX, int centerY, int radius, Corner corner, int color) {
            UpgradeScreen.draw(graphics, centerX, centerY, radius, color, corner == Corner.TOP_LEFT, corner == Corner.TOP_RIGHT, corner == Corner.BOTTOM_LEFT, corner == Corner.BOTTOM_RIGHT);
        }
    }

    private static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

