/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.auriny.omegatalents.network.RequestDamagePacket;
import ru.auriny.omegatalents.network.RequestPlayerDataPacket;
import ru.auriny.omegatalents.network.ResponseDamagePacket;
import ru.auriny.omegatalents.network.SyncOtherPlayerDataPacket;
import ru.auriny.omegatalents.network.SyncUpgradeDataPacket;
import ru.auriny.omegatalents.network.UpgradePacket;

public class PacketHandler {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    public static void register() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("omegatalents", "messages")).serverAcceptedVersions(s -> true).clientAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
        INSTANCE.registerMessage(packetId++, UpgradePacket.class, UpgradePacket::encode, UpgradePacket::decode, UpgradePacket::handle);
        INSTANCE.registerMessage(packetId++, SyncUpgradeDataPacket.class, SyncUpgradeDataPacket::encode, SyncUpgradeDataPacket::decode, SyncUpgradeDataPacket::handle);
        INSTANCE.registerMessage(packetId++, RequestPlayerDataPacket.class, RequestPlayerDataPacket::encode, RequestPlayerDataPacket::decode, RequestPlayerDataPacket::handle);
        INSTANCE.registerMessage(packetId++, SyncOtherPlayerDataPacket.class, SyncOtherPlayerDataPacket::toBytes, SyncOtherPlayerDataPacket::new, SyncOtherPlayerDataPacket::handle);
        INSTANCE.registerMessage(packetId++, RequestDamagePacket.class, RequestDamagePacket::encode, RequestDamagePacket::decode, RequestDamagePacket::handle);
        INSTANCE.registerMessage(packetId++, ResponseDamagePacket.class, ResponseDamagePacket::encode, ResponseDamagePacket::decode, ResponseDamagePacket::handle);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    static {
        packetId = 0;
    }
}

