/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.network;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.omegatalents.network.PacketHandler;
import ru.auriny.omegatalents.network.SyncOtherPlayerDataPacket;
import ru.auriny.omegatalents.utils.PlayerUpgradeData;
import ru.auriny.omegatalents.utils.UpgradeType;

public class RequestPlayerDataPacket {
    private final UUID targetPlayerUUID;

    public RequestPlayerDataPacket() {
        this.targetPlayerUUID = null;
    }

    public RequestPlayerDataPacket(UUID targetPlayerUUID) {
        this.targetPlayerUUID = targetPlayerUUID;
    }

    public static RequestPlayerDataPacket decode(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new RequestPlayerDataPacket(buf.m_130259_());
        }
        return new RequestPlayerDataPacket();
    }

    public static void encode(RequestPlayerDataPacket msg, FriendlyByteBuf buf) {
        boolean hasUUID = msg.targetPlayerUUID != null;
        buf.writeBoolean(hasUUID);
        if (hasUUID) {
            buf.m_130077_(msg.targetPlayerUUID);
        }
    }

    public static void handle(RequestPlayerDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer targetPlayer;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null || sender.m_20194_() == null) {
                return;
            }
            ServerPlayer serverPlayer = targetPlayer = msg.targetPlayerUUID != null ? sender.m_20194_().m_6846_().m_11259_(msg.targetPlayerUUID) : sender;
            if (targetPlayer != null) {
                Map<String, Integer> data = PlayerUpgradeData.getAllUpgradesEnum((Player)targetPlayer).entrySet().stream().collect(Collectors.toMap(e -> ((UpgradeType)((Object)((Object)((Object)e.getKey())))).getId(), Map.Entry::getValue));
                UUID finalUUID = msg.targetPlayerUUID != null ? msg.targetPlayerUUID : sender.m_20148_();
                PacketHandler.sendToPlayer(new SyncOtherPlayerDataPacket(finalUUID, data), sender);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

