/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ru.auriny.omegatalents.client.ClientUpgradeDataHandler;
import ru.justagod.cutter.invoke.Invoke;

public class SyncUpgradeDataPacket {
    private final Map<String, Integer> upgradeData;

    public SyncUpgradeDataPacket(Map<String, Integer> upgradeData) {
        this.upgradeData = upgradeData;
    }

    public static void encode(SyncUpgradeDataPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.upgradeData.size());
        for (Map.Entry<String, Integer> entry : msg.upgradeData.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public static SyncUpgradeDataPacket decode(FriendlyByteBuf buf) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            int value = buf.readInt();
            data.put(key, value);
        }
        return new SyncUpgradeDataPacket(data);
    }

    public static void handle(SyncUpgradeDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Invoke.client(() -> ClientUpgradeDataHandler.updateClientData(msg.upgradeData)));
        ctx.get().setPacketHandled(true);
    }
}

