/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.utils;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import ru.auriny.omegatalents.client.ClientPlayerDataManager;
import ru.auriny.omegatalents.client.ClientUpgradeDataHandler;
import ru.auriny.omegatalents.network.PacketHandler;
import ru.auriny.omegatalents.network.SyncUpgradeDataPacket;
import ru.auriny.omegatalents.utils.UpgradeType;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;
import ru.justagod.cutter.invoke.Invoke;

public class PlayerUpgradeData {
    protected static final String NBT_KEY = "player_upgrades";

    public static CompoundTag getUpgradeData(Player player) {
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.m_128441_(NBT_KEY)) {
            playerData.m_128365_(NBT_KEY, (Tag)new CompoundTag());
        }
        return playerData.m_128469_(NBT_KEY);
    }

    public static int getUpgradeLevel(Player player, UpgradeType type) {
        if (player.m_9236_().f_46443_) {
            Object result = Invoke.clientValue(() -> {
                if (player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                    return ClientUpgradeDataHandler.getUpgradeLevel(type.getId());
                }
                return 0;
            });
            return result == null ? 0 : (Integer)result;
        }
        return PlayerUpgradeData.getUpgradeData(player).m_128451_(type.getId());
    }

    public static int getTotalLevel(Player player) {
        if (player.m_9236_().m_5776_()) {
            Object result = Invoke.clientValue(() -> {
                if (player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                    int totalLevel = 0;
                    for (UpgradeType t : UpgradeType.values()) {
                        totalLevel += ClientUpgradeDataHandler.getUpgradeLevel(t.getId());
                    }
                    return totalLevel;
                }
                return ClientPlayerDataManager.getPlayerTotalLevel(player.m_20148_());
            });
            return result == null ? 0 : (Integer)result;
        }
        int totalLevel = 0;
        CompoundTag data = PlayerUpgradeData.getUpgradeData(player);
        for (UpgradeType type : UpgradeType.values()) {
            totalLevel += data.m_128451_(type.getId());
        }
        return totalLevel;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    public static void setUpgradeLevel(Player player, UpgradeType type, int level) {
        PlayerUpgradeData.getUpgradeData(player).m_128405_(type.getId(), level);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            PlayerUpgradeData.syncDataToClient((ServerPlayer)player);
        }
    }

    private static int getCurrentTotalXp(Player player) {
        return PlayerUpgradeData.getXpFromLevels(player.f_36078_) + Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static boolean canUpgrade(Player player, UpgradeType type) {
        int currentLevel = PlayerUpgradeData.getUpgradeLevel(player, type);
        if (currentLevel >= type.getMaxLevel()) {
            return false;
        }
        int requiredXp = PlayerUpgradeData.getRequiredXpCost(type, currentLevel + 1);
        return PlayerUpgradeData.getCurrentTotalXp(player) >= requiredXp;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    public static void upgradeSkill(Player player, UpgradeType type) {
        int currentLevel = PlayerUpgradeData.getUpgradeLevel(player, type);
        if (currentLevel >= PlayerUpgradeData.getMaxLevel(type)) {
            return;
        }
        int requiredXp = PlayerUpgradeData.getRequiredXpCost(type, currentLevel + 1);
        if (PlayerUpgradeData.getCurrentTotalXp(player) >= requiredXp) {
            player.m_6756_(-requiredXp);
            PlayerUpgradeData.setUpgradeLevel(player, type, currentLevel + 1);
            PlayerUpgradeData.applyUpgrade(player, type);
        }
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    public static void syncDataToClient(ServerPlayer player) {
        Map<String, Integer> allData = PlayerUpgradeData.getAllUpgradesEnum((Player)player).entrySet().stream().collect(Collectors.toMap(e -> ((UpgradeType)((Object)((Object)e.getKey()))).getId(), Map.Entry::getValue));
        PacketHandler.sendToPlayer(new SyncUpgradeDataPacket(allData), player);
    }

    public static EnumMap<UpgradeType, Integer> getAllUpgradesEnum(Player player) {
        EnumMap<UpgradeType, Integer> result = new EnumMap<UpgradeType, Integer>(UpgradeType.class);
        CompoundTag data = PlayerUpgradeData.getUpgradeData(player);
        for (UpgradeType type : UpgradeType.values()) {
            result.put(type, data.m_128451_(type.getId()));
        }
        return result;
    }

    @Deprecated
    public static Map<String, Integer> getAllUpgrades(Player player) {
        return PlayerUpgradeData.getAllUpgradesEnum(player).entrySet().stream().collect(Collectors.toMap(e -> ((UpgradeType)((Object)((Object)e.getKey()))).getId(), Map.Entry::getValue));
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    private static void applyUpgrade(Player player, UpgradeType type) {
        if (type.getAttribute() == null) {
            return;
        }
        int level = PlayerUpgradeData.getUpgradeLevel(player, type);
        double value = type.getValuePerLevel() * (double)level;
        PlayerUpgradeData.applyAttribute(player.m_21204_(), type.getAttribute(), type, value, type.getOperation());
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    private static void applyAttribute(AttributeMap attributes, Attribute attr, UpgradeType type, double value, AttributeModifier.Operation op) {
        AttributeInstance instance = attributes.m_22146_(attr);
        if (instance != null) {
            instance.m_22120_(PlayerUpgradeData.getUpgradeModifierId(type));
            instance.m_22125_(new AttributeModifier(PlayerUpgradeData.getUpgradeModifierId(type), type.getDisplayName() + " Upgrade", value, op));
        }
    }

    private static UUID getUpgradeModifierId(UpgradeType type) {
        return type.getModifierId() != null ? type.getModifierId() : UUID.randomUUID();
    }

    public static int getMaxLevel(UpgradeType type) {
        return type.getMaxLevel();
    }

    public static int getXpFromLevels(int levels) {
        if (levels <= 0) {
            return 0;
        }
        if (levels <= 16) {
            return levels * levels + 6 * levels;
        }
        if (levels <= 31) {
            return (int)(2.5 * (double)levels * (double)levels - 40.5 * (double)levels + 360.0);
        }
        return (int)(4.5 * (double)levels * (double)levels - 162.5 * (double)levels + 2220.0);
    }

    public static int getRequiredLevelCost(UpgradeType type, int targetUpgradeLevel) {
        return type.getLevelCost() * targetUpgradeLevel;
    }

    public static int getRequiredXpCost(UpgradeType type, int targetUpgradeLevel) {
        int levelCost = PlayerUpgradeData.getRequiredLevelCost(type, targetUpgradeLevel);
        return PlayerUpgradeData.getXpFromLevels(levelCost);
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    public static void resetUpgrades(Player player) {
        CompoundTag data = PlayerUpgradeData.getUpgradeData(player);
        for (UpgradeType type : UpgradeType.values()) {
            AttributeInstance instance;
            data.m_128405_(type.getId(), 0);
            if (type.getAttribute() == null || (instance = player.m_21051_(type.getAttribute())) == null) continue;
            instance.m_22120_(PlayerUpgradeData.getUpgradeModifierId(type));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerUpgradeData.syncDataToClient(serverPlayer);
            serverPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7d\u0412\u0441\u0435 \u043d\u0430\u0432\u044b\u043a\u0438 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u044b!"));
        }
    }
}

