/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.utils;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import pro.komaru.tridot.util.math.ArcRandom;
import ru.auriny.omegatalents.registries.OTAttributeRegistry;
import ru.auriny.omegatalents.utils.PlayerUpgradeData;
import ru.auriny.omegatalents.utils.UpgradeType;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@GradleSideOnly(value={GradleSide.SERVER})
public class PlayerUpgradeEventHandler {
    private static final ArcRandom RANDOM = new ArcRandom();

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        this.applyAllUpgrades(player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        this.applyAllUpgrades(player);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            CompoundTag oldData = event.getOriginal().getPersistentData();
            CompoundTag newData = event.getEntity().getPersistentData();
            if (oldData.m_128441_("player_upgrades")) {
                newData.m_128365_("player_upgrades", (Tag)oldData.m_128469_("player_upgrades").m_6426_());
            }
        }
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance attr = entity.m_21051_((Attribute)OTAttributeRegistry.REGENERATION.get());
        if (attr == null) {
            return;
        }
        double multiplier = attr.m_22135_();
        if (multiplier != 1.0) {
            float healAmount = event.getAmount();
            float newAmount = (float)((double)healAmount * multiplier);
            event.setAmount(newAmount);
        }
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            double critChance = player.m_21133_((Attribute)OTAttributeRegistry.CRITICAL_CHANCE.get()) / 100.0;
            if (player.m_20096_() && player.m_36403_(0.5f) > 0.9f && RANDOM.chance(critChance)) {
                event.setResult(Event.Result.ALLOW);
                event.setDamageModifier(1.33f);
            }
        }
    }

    private void applyAllUpgrades(Player player) {
        for (UpgradeType type : UpgradeType.values()) {
            int level = PlayerUpgradeData.getUpgradeLevel(player, type);
            if (level <= 0) continue;
            this.applyUpgrade(player, type, level);
        }
    }

    private void applyUpgrade(Player player, UpgradeType upgradeType, int level) {
        AttributeMap attributes = player.m_21204_();
        Attribute attribute = upgradeType.getAttribute();
        UUID modifierId = upgradeType.getModifierId();
        if (attribute == null || modifierId == null) {
            return;
        }
        AttributeInstance instance = attributes.m_22146_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(modifierId);
        double value = (double)level * upgradeType.getValuePerLevel();
        instance.m_22125_(new AttributeModifier(modifierId, upgradeType.getDisplayName() + " Upgrade", value, upgradeType.getOperation()));
        PlayerUpgradeData.syncDataToClient((ServerPlayer)player);
    }
}

