/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.omegatalents.utils;

import divinerpg.registries.AttributesRegistry;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import ru.auriny.omegatalents.registries.OTAttributeRegistry;

public enum UpgradeType {
    DAMAGE("damage", 5, "\u0410\u0442\u0430\u043a\u0430", "\u2694", "+%s%% \u0443\u0440\u043e\u043d\u0430 \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 5, "c85da346-36fd-4c04-b50a-6797111e8854", Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE, 0.015),
    CRIT_CHANCE("crit_chance", 6, "\u0428\u0430\u043d\u0441 \u043a\u0440\u0438\u0442. \u0443\u0434\u0430\u0440\u0430", "\ud83d\udca2", "+%s%% \u043a \u0448\u0430\u043d\u0441\u0443 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0443\u0434\u0430\u0440\u0430 \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 3, "32b19d41-5af7-4390-8c44-a465357a7adc", (Attribute)OTAttributeRegistry.CRITICAL_CHANCE.get(), AttributeModifier.Operation.ADDITION, 4.0),
    HEALTH("health", 4, "\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435", "\u2764", "+%s \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 6, "a0d39cd2-b253-464c-be8d-97b7415029b0", Attributes.f_22276_, AttributeModifier.Operation.ADDITION, 0.5),
    REGENERATION("regeneration", 7, "\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f", "\u2661", "+%s%% \u043d\u0430\u0442\u0443\u0440\u0430\u043b\u044c\u043d\u043e\u0439 \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 2, "2b74810a-605e-424b-8c92-e213606a5a6d", (Attribute)OTAttributeRegistry.REGENERATION.get(), AttributeModifier.Operation.MULTIPLY_BASE, 0.12),
    ARMOR("armor", 4, "\u0417\u0430\u0449\u0438\u0442\u0430", "\ud83d\udee1", "+%s%% \u0431\u0440\u043e\u043d\u0438 \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 5, "0d1bf139-6428-4477-b687-3f16c9a7e8bc", (Attribute)AttributeRegistry.PERCENT_ARMOR.get(), AttributeModifier.Operation.ADDITION, 0.4),
    MAX_ARCANA("max_arcana", 6, "\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0440\u043a\u0430\u043d\u0430", "\u2b50", "+%s \u0410\u0440\u043a\u0430\u043d\u044b \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 4, "50d1a3aa-6b20-4154-b215-4b8ac2c25214", (Attribute)AttributesRegistry.ARCANA_MAX.get(), AttributeModifier.Operation.ADDITION, 5.0),
    REGEN_ARCANA("regen_arcana", 9, "\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0410\u0440\u043a\u0430\u043d\u044b", "\u2606", "+%s%% \u043a \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0410\u0440\u043a\u0430\u043d\u044b \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 2, "ca8000ca-de73-4706-af52-aab5b2e4ac0f", (Attribute)AttributesRegistry.ARCANA_REGEN.get(), AttributeModifier.Operation.MULTIPLY_BASE, 0.075),
    SPEED("speed", 9, "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c", "\u26a1", "+%s%% \u043a \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u0437\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c", 3, "35f02dfa-a6f5-464b-a4fb-bee2419f74a1", Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, 0.025);

    private final String id;
    private final int levelCost;
    private final String displayName;
    private final String icon;
    private final String descriptionTemplate;
    private final int maxLevel;
    private final UUID modifierId;
    private final Attribute attribute;
    private final AttributeModifier.Operation operation;
    private final double valuePerLevel;
    private static final Map<String, UpgradeType> BY_ID;

    private UpgradeType(String id, int levelCost, String displayName, String icon, String descriptionTemplate, int maxLevel, String uuid, Attribute attribute, AttributeModifier.Operation operation, double valuePerLevel) {
        this.id = id;
        this.levelCost = levelCost;
        this.displayName = displayName;
        this.icon = icon;
        this.descriptionTemplate = descriptionTemplate;
        this.maxLevel = maxLevel;
        this.modifierId = uuid != null ? UUID.fromString(uuid) : null;
        this.attribute = attribute;
        this.operation = operation;
        this.valuePerLevel = valuePerLevel;
    }

    public String getId() {
        return this.id;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public UUID getModifierId() {
        return this.modifierId;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public AttributeModifier.Operation getOperation() {
        return this.operation;
    }

    public double getValuePerLevel() {
        return this.valuePerLevel;
    }

    public String getDescription() {
        double value = this.operation == AttributeModifier.Operation.MULTIPLY_BASE ? this.valuePerLevel * 100.0 : this.valuePerLevel;
        return String.format(this.descriptionTemplate, value % 1.0 == 0.0 ? String.format("%.0f", value) : String.format("%.1f", value));
    }

    public static UpgradeType byId(String id) {
        return BY_ID.get(id);
    }

    static {
        BY_ID = Arrays.stream(UpgradeType.values()).collect(Collectors.toMap(UpgradeType::getId, t -> t));
    }
}

