/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.particle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDescription;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public final class ClientParticleTypesManager
implements PreparableReloadListener {
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.m_246568_((String)"particles");
    private static final ResourceLocation PARTICLES_ATLAS_INFO = new ResourceLocation("particles");
    private final Map<ResourceLocation, ParticleProvider<?>> providers = Maps.newHashMap();
    private final Map<ResourceLocation, MutableSpriteSet> spriteSets = Maps.newHashMap();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private boolean hasBeenReloaded;

    public <T extends ParticleOptions> void register(ResourceLocation identifier, ParticleProvider<T> particleFactory) {
        this.providers.put(identifier, particleFactory);
    }

    public <T extends ParticleOptions> void register(ResourceLocation identifier, ParticleProvider.Sprite<T> sprite) {
        this.register(identifier, spriteSet -> (particleOptions, clientLevel, x, y, z, xd, yd, zd) -> {
            TextureSheetParticle textureSheetParticle = sprite.m_272232_(particleOptions, clientLevel, x, y, z, xd, yd, zd);
            if (textureSheetParticle != null) {
                textureSheetParticle.m_108335_(spriteSet);
            }
            return textureSheetParticle;
        });
    }

    public <T extends ParticleOptions> void register(ResourceLocation identifier, ParticleEngine.SpriteParticleRegistration<T> particleMetaFactory) {
        MutableSpriteSet mutableSpriteSet = new MutableSpriteSet();
        this.spriteSets.put(identifier, mutableSpriteSet);
        this.providers.put(identifier, particleMetaFactory.m_107419_((SpriteSet)mutableSpriteSet));
    }

    @Nullable
    public Particle createParticle(ResourceLocation identifier, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = this.makeParticle(identifier, particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.minecraft.f_91061_.m_107344_(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(ResourceLocation identifier, T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ParticleProvider<?> particleProvider;
        if (!this.hasBeenReloaded) {
            ContentRegistrationFlags.throwForFlag(ContentRegistrationFlags.CLIENT_PARTICLE_TYPES);
        }
        return (particleProvider = this.providers.get(identifier)) == null ? null : particleProvider.m_6966_(particleData, this.minecraft.f_91073_, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        this.hasBeenReloaded = false;
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.m_247457_(resourceManager), backgroundExecutor).thenCompose(resourceMap -> {
            ArrayList list = new ArrayList(resourceMap.size());
            resourceMap.forEach((p_247903_, p_247904_) -> {
                ResourceLocation resourcelocation = PARTICLE_LISTER.m_245273_(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(ResourceLocation id, Optional<List<ResourceLocation>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (Resource)p_247904_));
                }, backgroundExecutor));
            });
            return Util.m_137567_(list);
        });
        TextureAtlas textureAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_174786_(TextureAtlas.f_118260_, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        CompletionStage completablefuture1 = SpriteLoader.m_245483_((TextureAtlas)textureAtlas).m_260881_(resourceManager, PARTICLES_ATLAS_INFO, 0, backgroundExecutor).thenCompose(SpriteLoader.Preparations::m_246429_);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$7(reloadProfiler, (CompletableFuture)completablefuture1, textureAtlas, (CompletableFuture)completablefuture, arg_0), gameExecutor);
    }

    private Optional<List<ResourceLocation>> loadParticleDescription(ResourceLocation registryName, Resource resource) {
        if (!this.spriteSets.containsKey(registryName)) {
            return Optional.empty();
        }
        try {
            Optional<List<ResourceLocation>> optional;
            try (BufferedReader reader = resource.m_215508_();){
                ParticleDescription particleDescription = ParticleDescription.m_107285_((JsonObject)GsonHelper.m_13859_((Reader)reader));
                optional = Optional.of(particleDescription.m_107282_());
            }
            return optional;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load description for particle " + registryName, e);
        }
    }

    private /* synthetic */ void lambda$reload$7(ProfilerFiller reloadProfiler, CompletableFuture completablefuture1, TextureAtlas textureAtlas, CompletableFuture completablefuture, Void $) {
        reloadProfiler.m_7242_();
        reloadProfiler.m_6180_("upload");
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)completablefuture1.join();
        textureAtlas.m_247065_(spriteloader$preparations);
        reloadProfiler.m_6182_("bindSpriteSets");
        HashSet set = new HashSet();
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.f_243912_();
        ((List)completablefuture.join()).forEach(particleDefinition -> {
            Optional<List<ResourceLocation>> optional = particleDefinition.sprites();
            if (!optional.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourcelocation : optional.get()) {
                    TextureAtlasSprite textureatlassprite1 = (TextureAtlasSprite)spriteloader$preparations.f_243807_().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(particleDefinition.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            PuzzlesLib.LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
        reloadProfiler.m_7238_();
        reloadProfiler.m_7241_();
        this.hasBeenReloaded = true;
    }

    private static class MutableSpriteSet
    implements SpriteSet {
        private List<TextureAtlasSprite> sprites;

        private MutableSpriteSet() {
        }

        public TextureAtlasSprite m_5819_(int age, int lifetime) {
            return this.sprites.get(age * (this.sprites.size() - 1) / lifetime);
        }

        public TextureAtlasSprite m_213979_(RandomSource random) {
            return this.sprites.get(random.m_188503_(this.sprites.size()));
        }

        public void rebind(List<TextureAtlasSprite> sprites) {
            this.sprites = ImmutableList.copyOf(sprites);
        }
    }
}

