/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProviderRegistry;
import com.misterpemodder.shulkerboxtooltip.forge.ShulkerBoxTooltipImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.ConfigurationHandler;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.provider.EnderChestPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.util.NamedLogger;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
@ApiStatus.Internal
public class ShulkerBoxTooltip
implements ShulkerBoxTooltipApi {
    public static final String MOD_ID = "shulkerboxtooltip";
    public static final String MOD_NAME = "ShulkerBoxTooltip";
    public static final NamedLogger LOGGER = new NamedLogger(LogManager.getFormatterLogger((String)"ShulkerBoxTooltip"));
    public static Configuration config;
    public static Configuration savedConfig;
    public static final Item[] SHULKER_BOX_ITEMS;

    public static void init() {
        savedConfig = ConfigurationHandler.register();
        config = ConfigurationHandler.copyOf(savedConfig);
        ServerNetworking.init();
    }

    private static void register(PreviewProviderRegistry registry, String id, PreviewProvider provider, Item ... items) {
        registry.register(ShulkerBoxTooltipUtil.id(id), provider, items);
    }

    @Override
    public void registerProviders(PreviewProviderRegistry registry) {
        ShulkerBoxTooltip.register(registry, "shulker_box", new ShulkerBoxPreviewProvider(), SHULKER_BOX_ITEMS);
        ShulkerBoxTooltip.register(registry, "chest_like", new BlockEntityPreviewProvider(27, true), Items.f_42009_, Items.f_42149_, Items.f_42768_);
        ShulkerBoxTooltip.register(registry, "furnace_like", new BlockEntityPreviewProvider(3, false, 1), Items.f_41962_, Items.f_42770_, Items.f_42769_);
        ShulkerBoxTooltip.register(registry, "dropper_like", new BlockEntityPreviewProvider(9, true, 3), Items.f_42162_, Items.f_41855_);
        ShulkerBoxTooltip.register(registry, "hopper", new BlockEntityPreviewProvider(5, true, 5), Items.f_42155_);
        ShulkerBoxTooltip.register(registry, "brewing_stand", new BlockEntityPreviewProvider(5, false, 3), Items.f_42543_);
        ShulkerBoxTooltip.register(registry, "ender_chest", new EnderChestPreviewProvider(), Items.f_42108_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerColors(ColorRegistry registry) {
        registry.defaultCategory().register(ColorKey.DEFAULT, "default").register(ColorKey.ENDER_CHEST, "ender_chest", ShulkerBoxTooltip.blockName("ender_chest"));
        registry.category(ShulkerBoxTooltipUtil.id("shulker_boxes")).register(ColorKey.SHULKER_BOX, "shulker_box", ShulkerBoxTooltip.blockName("shulker_box")).register(ColorKey.WHITE_SHULKER_BOX, "white_shulker_box", ShulkerBoxTooltip.blockName("white_shulker_box")).register(ColorKey.ORANGE_SHULKER_BOX, "orange_shulker_box", ShulkerBoxTooltip.blockName("orange_shulker_box")).register(ColorKey.MAGENTA_SHULKER_BOX, "magenta_shulker_box", ShulkerBoxTooltip.blockName("magenta_shulker_box")).register(ColorKey.LIGHT_BLUE_SHULKER_BOX, "light_blue_shulker_box", ShulkerBoxTooltip.blockName("light_blue_shulker_box")).register(ColorKey.YELLOW_SHULKER_BOX, "yellow_shulker_box", ShulkerBoxTooltip.blockName("yellow_shulker_box")).register(ColorKey.LIME_SHULKER_BOX, "lime_shulker_box", ShulkerBoxTooltip.blockName("lime_shulker_box")).register(ColorKey.PINK_SHULKER_BOX, "pink_shulker_box", ShulkerBoxTooltip.blockName("pink_shulker_box")).register(ColorKey.GRAY_SHULKER_BOX, "gray_shulker_box", ShulkerBoxTooltip.blockName("gray_shulker_box")).register(ColorKey.LIGHT_GRAY_SHULKER_BOX, "light_gray_shulker_box", ShulkerBoxTooltip.blockName("light_gray_shulker_box")).register(ColorKey.CYAN_SHULKER_BOX, "cyan_shulker_box", ShulkerBoxTooltip.blockName("cyan_shulker_box")).register(ColorKey.PURPLE_SHULKER_BOX, "purple_shulker_box", ShulkerBoxTooltip.blockName("purple_shulker_box")).register(ColorKey.BLUE_SHULKER_BOX, "blue_shulker_box", ShulkerBoxTooltip.blockName("blue_shulker_box")).register(ColorKey.BROWN_SHULKER_BOX, "brown_shulker_box", ShulkerBoxTooltip.blockName("brown_shulker_box")).register(ColorKey.GREEN_SHULKER_BOX, "green_shulker_box", ShulkerBoxTooltip.blockName("green_shulker_box")).register(ColorKey.RED_SHULKER_BOX, "red_shulker_box", ShulkerBoxTooltip.blockName("red_shulker_box")).register(ColorKey.BLACK_SHULKER_BOX, "black_shulker_box", ShulkerBoxTooltip.blockName("black_shulker_box"));
    }

    private static String blockName(String block) {
        return "block.minecraft." + block;
    }

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return ShulkerBoxTooltipImpl.isClient();
    }

    @ExpectPlatform
    @Contract(value="-> _", pure=true)
    @ExpectPlatform.Transformed
    public static Path getConfigDir() {
        return ShulkerBoxTooltipImpl.getConfigDir();
    }

    static {
        SHULKER_BOX_ITEMS = new Item[]{Items.f_42265_, Items.f_42266_, Items.f_42267_, Items.f_42268_, Items.f_42269_, Items.f_42270_, Items.f_42271_, Items.f_42272_, Items.f_42273_, Items.f_42274_, Items.f_42275_, Items.f_42224_, Items.f_42225_, Items.f_42226_, Items.f_42227_, Items.f_42228_, Items.f_42229_};
    }
}

