/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import org.lwjgl.glfw.GLFW;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.controls.IKeyBindingHelper;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.platform.Services;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.hud.HudSession;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected HudSession hudSession;

    public ControlsHandler(IXaeroMinimap modMain, HudSession hudSession) {
        this.modMain = modMain;
        this.hudSession = hudSession;
    }

    public void setKeyState(KeyMapping kb, boolean pressed) {
        KeyMapping.m_90837_((InputConstants.Key)Services.PLATFORM.getKeyBindingHelper().getBoundKeyOf(kb), (boolean)pressed);
    }

    public boolean isDown(KeyMapping kb) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (keyBindingHelper.getBoundKeyOf(kb).m_84873_() == -1) {
            return false;
        }
        if (keyBindingHelper.getBoundKeyOf(kb).m_84868_() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyBindingHelper.getBoundKeyOf(kb).m_84873_()) == 1;
        }
        if (keyBindingHelper.getBoundKeyOf(kb).m_84868_() == InputConstants.Type.KEYSYM) {
            return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyBindingHelper.getBoundKeyOf(kb).m_84873_());
        }
        return false;
    }

    public void keyDownPre(KeyMapping kb) {
    }

    public void keyDownPost(KeyMapping kb) {
    }

    public void keyDown(KeyMapping kb, boolean tickEnd, boolean isRepeat) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager waypointsManager = session.getWorldManager();
        Minecraft mc = Minecraft.m_91087_();
        if (!tickEnd) {
            MinimapWorld currentWorld;
            Screen currentEscScreen;
            Screen current;
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI(session)) {
                mc.m_91152_((Screen)new GuiAddWaypoint((HudMod)this.modMain, session, null, (ArrayList<Waypoint>)Lists.newArrayList(), session.getWorldState().getCurrentWorldPath().getRoot(), waypointsManager.getCurrentWorld(), true));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI(session)) {
                current = mc.f_91080_;
                currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                mc.m_91152_((Screen)new GuiWaypoints((HudMod)this.modMain, session, current, currentEscScreen));
            }
            if (kb == ModSettings.keyLargeMap) {
                session.getProcessor().setEnlargedMap(this.modMain.getSettings().enlargedMinimapAToggle ? !session.getProcessor().isEnlargedMap() : true);
                session.getProcessor().setToResetImage(true);
                session.getProcessor().instantZoom();
            }
            if (kb == ModSettings.keyToggleMap && !Misc.hasEffect((Player)mc.f_91074_, Effects.NO_MINIMAP) && !Misc.hasEffect((Player)mc.f_91074_, Effects.NO_MINIMAP_HARMFUL)) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.MINIMAP);
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.INGAME_WAYPOINTS);
            }
            if (kb == ModSettings.keyToggleMapWaypoints) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.WAYPOINTS);
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded(this.hudSession) && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        current = mc.f_91080_;
                        currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                        Minecraft.m_91087_().m_91152_((Screen)new GuiSlimeSeed(this.modMain, session, current, currentEscScreen));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyInstantWaypoint && !Misc.hasEffect((Player)mc.f_91074_, Effects.NO_WAYPOINTS) && !Misc.hasEffect((Player)mc.f_91074_, Effects.NO_WAYPOINTS_HARMFUL)) {
                session.getWaypointSession().getTemporaryHandler().createTemporaryWaypoint(waypointsManager.getCurrentWorld(), OptimizedMath.myFloor(mc.f_91075_.m_20185_()), OptimizedMath.myFloor(mc.f_91075_.m_20186_() + 0.0625), OptimizedMath.myFloor(mc.f_91075_.m_20189_()));
            }
            if (kb == ModSettings.keySwitchSet && (currentWorld = waypointsManager.getCurrentWorld()) != null) {
                ArrayList<KeySortableByOther<Object>> keysList = new ArrayList<KeySortableByOther<Object>>();
                for (WaypointSet set : currentWorld.getIterableWaypointSets()) {
                    String key = set.getName();
                    keysList.add(new KeySortableByOther<Object>(key, new Comparable[]{I18n.m_118938_((String)key, (Object[])new Object[0]).toLowerCase()}));
                }
                Collections.sort(keysList);
                boolean foundCurrent = false;
                String firstSetKey = null;
                for (KeySortableByOther keySortableByOther : keysList) {
                    String setKey = (String)keySortableByOther.getKey();
                    if (firstSetKey == null) {
                        firstSetKey = setKey;
                    }
                    if (setKey != null && setKey.equals(currentWorld.getCurrentWaypointSetId())) {
                        foundCurrent = true;
                        continue;
                    }
                    if (!foundCurrent) continue;
                    foundCurrent = false;
                    currentWorld.setCurrentWaypointSetId(setKey);
                    break;
                }
                if (foundCurrent) {
                    currentWorld.setCurrentWaypointSetId(firstSetKey);
                }
                session.getWorldStateUpdater().update();
                session.getWaypointSession().setSetChangedTime(System.currentTimeMillis());
                try {
                    session.getWorldManagerIO().saveWorld(currentWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyAllSets) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.WAYPOINTS_ALL_SETS);
            }
            if (kb == ModSettings.keyLightOverlay) {
                this.modMain.getSettings().lightOverlayType = this.modMain.getSettings().lightOverlayType == 0 ? 1 : (this.modMain.getSettings().lightOverlayType *= -1);
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (!session.getProcessor().isEnlargedMap() || this.modMain.getSettings().zoomOnEnlarged == 0) {
                int zoomChange = 0;
                if (kb == ModSettings.keyBindZoom) {
                    zoomChange = 1;
                }
                if (kb == ModSettings.keyBindZoom1) {
                    zoomChange = -1;
                }
                if (zoomChange != 0) {
                    this.modMain.getSettings().changeZoom(zoomChange);
                    try {
                        this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            if (kb == ModSettings.keyToggleRadar) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.RADAR_DISPLAYED);
            } else if (kb == ModSettings.keyManualCaveMode) {
                session.getProcessor().toggleManualCaveMode();
            } else if (kb == ModSettings.keyToggleTrackedPlayersOnMap) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.TRACKED_PLAYERS_ON_MAP);
            } else if (kb == ModSettings.keyToggleTrackedPlayersInWorld) {
                this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.TRACKED_PLAYERS_IN_WORLD);
            } else if (kb == ModSettings.keyTogglePacChunkClaims) {
                if (this.modMain.getSupportMods().worldmap() && this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
                    this.modMain.getSupportMods().worldmapSupport.toggleChunkClaims();
                } else {
                    this.modMain.getSettings().toggleBooleanOptionValue(ModOptions.PAC_CLAIMS);
                }
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyMapping kb) {
    }

    public void keyUpPost(KeyMapping kb) {
    }

    public void keyUp(KeyMapping kb, boolean tickEnd) {
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (!this.modMain.getSettings().enlargedMinimapAToggle && kb == ModSettings.keyLargeMap) {
                minimapSession.getProcessor().setEnlargedMap(false);
                minimapSession.getProcessor().setToResetImage(true);
                minimapSession.getProcessor().instantZoom();
            }
            this.keyUpPost(kb);
        }
    }
}

