/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.element;

import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.element.render.MinimapElementRenderProvider;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.render.radar.element.RadarRenderContext;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;

public final class RadarRenderProvider
extends MinimapElementRenderProvider<Entity, RadarRenderContext> {
    private boolean used;
    private Iterator<MinimapRadarList> entityLists;
    private MinimapRadarList currentList;
    private MinimapRadarList listForContext;
    private int currentListIndex;

    @Override
    public void begin(int location, RadarRenderContext context) {
        this.begin(MinimapElementRenderLocation.fromIndex(location), context);
    }

    @Override
    public boolean hasNext(int location, RadarRenderContext context) {
        return this.hasNext(MinimapElementRenderLocation.fromIndex(location), context);
    }

    @Override
    public Entity setupContextAndGetNext(int location, RadarRenderContext context) {
        return this.setupContextAndGetNext(MinimapElementRenderLocation.fromIndex(location), context);
    }

    @Override
    public Entity getNext(int location, RadarRenderContext context) {
        return this.getNext(MinimapElementRenderLocation.fromIndex(location), context);
    }

    @Override
    public void end(int location, RadarRenderContext context) {
        this.end(MinimapElementRenderLocation.fromIndex(location), context);
    }

    @Override
    public void begin(MinimapElementRenderLocation location, RadarRenderContext context) {
        this.used = true;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        MinimapProcessor minimap = minimapSession.getMinimapProcessor();
        context.minimapRadar = minimap.getEntityRadar();
        context.reversedOrder = ModSettings.keyReverseEntityRadar.m_90857_();
        context.renderEntity = Minecraft.m_91087_().m_91288_();
        Screen screenBU = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().f_91080_ = null;
        context.playerListDown = Minecraft.m_91087_().f_91066_.f_92099_.m_90857_() || ModSettings.keyAlternativeListPlayers.m_90857_();
        Minecraft.m_91087_().f_91080_ = screenBU;
        this.entityLists = context.minimapRadar.getRadarListsIterator();
        this.currentList = null;
        this.listForContext = null;
        this.currentListIndex = 0;
    }

    private void ensureList(MinimapElementRenderLocation location, RadarRenderContext context) {
        block0: while (this.currentList == null || this.currentListIndex >= this.currentList.getEntities().size() || this.currentListIndex < 0) {
            do {
                if (!this.entityLists.hasNext()) {
                    this.currentList = null;
                    this.currentListIndex = 0;
                    break block0;
                }
                this.currentList = this.entityLists.next();
                int n = this.currentListIndex = context.reversedOrder ? this.currentList.getEntities().size() - 1 : 0;
            } while (this.currentList != null && (location == MinimapElementRenderLocation.IN_MINIMAP || location == MinimapElementRenderLocation.OVER_MINIMAP) && location == MinimapElementRenderLocation.IN_MINIMAP == this.shouldRenderOverMinimap(this.currentList.getCategory(), context));
        }
    }

    private boolean shouldRenderOverMinimap(EntityRadarCategory category, RadarRenderContext context) {
        int settingValue = this.currentList.getCategory().getSettingValue(EntityRadarCategorySettings.RENDER_OVER_MINIMAP).intValue();
        return settingValue == 2 || settingValue == 1 && context.playerListDown;
    }

    @Override
    public boolean hasNext(MinimapElementRenderLocation location, RadarRenderContext context) {
        this.ensureList(location, context);
        return this.currentList != null && (!context.reversedOrder && this.currentListIndex < this.currentList.getEntities().size() || context.reversedOrder && this.currentListIndex >= 0);
    }

    @Override
    public Entity setupContextAndGetNext(MinimapElementRenderLocation location, RadarRenderContext context) {
        Entity result;
        if (this.listForContext != this.currentList) {
            this.setupContextForCategory(this.currentList.getCategory(), context);
            this.listForContext = this.currentList;
        }
        if ((result = this.getNext(location, context)) == null) {
            return null;
        }
        this.setupContextForEntity(result, context);
        return result;
    }

    public void setupContextForCategory(EntityRadarCategory entityCategory, RadarRenderContext context) {
        context.entityCategory = entityCategory;
        context.iconScale = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
        context.dotSize = entityCategory.getSettingValue(EntityRadarCategorySettings.DOT_SIZE).intValue();
        context.dotScale = 1.0 + 0.5 * (double)(context.dotSize - 1);
        context.heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue();
        context.heightBasedFade = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
        context.startFadingAt = entityCategory.getSettingValue(EntityRadarCategorySettings.START_FADING_AT).intValue();
        context.displayNameWhenIconFails = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
        context.alwaysNameTags = entityCategory.getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
        context.colorIndex = entityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
        context.displayY = entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAY_Y).intValue();
        int icons = entityCategory.getSettingValue(EntityRadarCategorySettings.ICONS).intValue();
        context.nameSettingForList = entityCategory.getSettingValue(EntityRadarCategorySettings.NAMES).intValue();
        context.namesForList = context.nameSettingForList == 1 && context.playerListDown || context.nameSettingForList == 2;
        context.iconsForList = icons == 1 && context.playerListDown || icons == 2;
    }

    public void setupContextForEntity(Entity entity, RadarRenderContext context) {
        boolean name = context.namesForList;
        boolean icon = context.iconsForList;
        if (!name && !(entity instanceof Player)) {
            name = context.alwaysNameTags && entity.m_8077_();
        }
        context.name = name;
        context.icon = icon;
    }

    @Override
    public Entity getNext(MinimapElementRenderLocation location, RadarRenderContext context) {
        Entity result = null;
        result = this.currentList.getEntities().get(this.currentListIndex);
        this.currentListIndex += context.reversedOrder ? -1 : 1;
        if (context.renderEntity == result) {
            return null;
        }
        return result;
    }

    @Override
    public void end(MinimapElementRenderLocation location, RadarRenderContext context) {
        this.used = false;
        context.minimapRadar = null;
        context.renderEntity = null;
    }

    public boolean isUsed() {
        return this.used;
    }
}

