/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationsManager;
import nl.enjarai.a_good_place.pack.state_tests.BlockStatePredicateType;
import nl.enjarai.a_good_place.particles.BlocksParticlesManager;
import org.jetbrains.annotations.Nullable;

@Mod(value="a_good_place")
public class AGoodPlaceImpl {
    public static final String MOD_ID = "a_good_place";

    public AGoodPlaceImpl() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
            AGoodPlaceImpl.addClientReloadListener(AnimationsManager::new, AGoodPlace.res("animations"));
            boolean firstInstall = AGoodPlace.copySamplePackIfNotPresent();
            MinecraftForge.EVENT_BUS.register((Object)this);
            AGoodPlaceImpl.registerOptionalTexturePack(AGoodPlace.res("default_animations"), Component.m_130674_((String)"Default Place Animations"), firstInstall);
            BlockStatePredicateType.init();
            AGoodPlace.IS_DEV = !FMLLoader.isProduction();
        }
    }

    public void onSetup(FMLClientSetupEvent event) {
        AGoodPlace.onSetup(null);
    }

    @SubscribeEvent
    public void onLevelLoad(ClientPlayerNetworkEvent.LoggingIn event) {
        AnimationsManager.populateTags(event.getPlayer().m_9236_().m_9598_());
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            BlocksParticlesManager.clear();
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            BlocksParticlesManager.renderParticles(event.getPoseStack(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.LevelTickEvent tickEvent) {
        if (tickEvent.phase == TickEvent.Phase.END && tickEvent.level.f_46443_) {
            BlocksParticlesManager.tickParticles((ClientLevel)tickEvent.level);
        }
    }

    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.m_216335_((long)seed), ModelData.EMPTY)) {
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
            dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, state, pos, poseStack, vertexConsumer, false, RandomSource.m_216327_(), state.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        }
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void registerOptionalTexturePack(ResourceLocation folderName, Component displayName, boolean defaultEnabled) {
        AGoodPlaceImpl.registerResourcePack(PackType.CLIENT_RESOURCES, () -> {
            Pack pack;
            IModFile file = ModList.get().getModFileById(folderName.m_135827_()).getFile();
            PathPackResources pack2 = new PathPackResources(folderName.toString(), true, file.findResource(new String[]{"resourcepacks/" + folderName.m_135815_()}));
            try {
                PackMetadataSection metadata = Objects.requireNonNull((PackMetadataSection)pack2.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_));
                pack = Pack.m_245512_((String)folderName.toString(), (Component)displayName, (boolean)defaultEnabled, s -> pack2, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.m_10374_(), FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        pack2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ee) {
                    if (!DatagenModLoader.isRunningDataGen()) {
                        ee.printStackTrace();
                    }
                    return null;
                }
            }
            pack2.close();
            return pack;
        });
    }

    public static void registerResourcePack(PackType packType, @Nullable Supplier<Pack> packSupplier) {
        if (packSupplier == null) {
            return;
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Consumer<AddPackFindersEvent> consumer = event -> {
            Pack p;
            if (event.getPackType() == packType && (p = (Pack)packSupplier.get()) != null) {
                event.addRepositorySource(arg_0 -> AGoodPlaceImpl.lambda$registerResourcePack$3((Supplier)packSupplier, arg_0));
            }
        };
        bus.addListener(consumer);
    }

    private static /* synthetic */ void lambda$registerResourcePack$3(Supplier packSupplier, Consumer infoConsumer) {
        infoConsumer.accept((Pack)packSupplier.get());
    }
}

