/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.pack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.StrOpt;
import nl.enjarai.a_good_place.pack.state_tests.BlockStatePredicate;

public record AnimationParameters(LazyList<?, BlockStatePredicate> predicates, int priority, int duration, float scaleStart, float scaleCurve, Vec3 translation, float translationCurve, Vec3 rotation, Vec3 pivot, float rotationCurve, float heightStart, float heightCurve, boolean restrictDirection, Optional<Holder<SoundEvent>> sound) {
    private static final Codec<Float> FLOAT_CODEC = AnimationParameters.floatRangeExclusive(-1.0f, 1.0f);
    private static final Codec<Float> DEG_TO_RAD_CODEC = Codec.floatRange((float)-180.0f, (float)180.0f).xmap(d -> Float.valueOf((float)Math.toRadians(d.floatValue())), r -> Float.valueOf((float)Math.toDegrees(r.floatValue())));
    public static final Codec<Vec3> ANGLE_VEC_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DEG_TO_RAD_CODEC.fieldOf("x").forGetter(o -> Float.valueOf((float)o.m_7096_())), (App)DEG_TO_RAD_CODEC.fieldOf("y").forGetter(o -> Float.valueOf((float)o.m_7098_())), (App)DEG_TO_RAD_CODEC.fieldOf("z").forGetter(o -> Float.valueOf((float)o.m_7094_()))).apply((Applicative)instance, Vec3::new));
    public static final Codec<Vec3> VEC_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(Vec3::m_7096_), (App)Codec.DOUBLE.fieldOf("y").forGetter(Vec3::m_7098_), (App)Codec.DOUBLE.fieldOf("z").forGetter(Vec3::m_7094_)).apply((Applicative)instance, Vec3::new));
    public static final Codec<AnimationParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(LazyList.codec(BlockStatePredicate.CODEC), "predicates", new LazyList(null, null)).forGetter(AnimationParameters::predicates), (App)StrOpt.of(Codec.INT, "priority", 0).forGetter(AnimationParameters::priority), (App)StrOpt.of(Codec.intRange((int)0, (int)300), "duration", 4).forGetter(AnimationParameters::duration), (App)StrOpt.of(Codec.floatRange((float)0.0f, (float)10.0f), "scale", Float.valueOf(1.0f)).forGetter(AnimationParameters::scaleStart), (App)StrOpt.of(FLOAT_CODEC, "scale_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::scaleCurve), (App)StrOpt.of(VEC_CODEC, "translation", Vec3.f_82478_).forGetter(AnimationParameters::translation), (App)StrOpt.of(FLOAT_CODEC, "translation_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::translationCurve), (App)StrOpt.of(ANGLE_VEC_CODEC, "rotation", Vec3.f_82478_).forGetter(AnimationParameters::rotation), (App)StrOpt.of(VEC_CODEC, "rotation_pivot", Vec3.f_82478_).forGetter(AnimationParameters::pivot), (App)StrOpt.of(FLOAT_CODEC, "rotation_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::rotationCurve), (App)StrOpt.of(Codec.floatRange((float)0.0f, (float)10.0f), "height", Float.valueOf(1.0f)).forGetter(AnimationParameters::heightStart), (App)StrOpt.of(FLOAT_CODEC, "height_curve", Float.valueOf(0.5f)).forGetter(AnimationParameters::heightCurve), (App)StrOpt.of(Codec.BOOL, "restrict_direction", true).forGetter(AnimationParameters::restrictDirection), (App)StrOpt.of(SoundEvent.f_263130_, "sound").forGetter(AnimationParameters::sound)).apply((Applicative)instance, AnimationParameters::new));

    public boolean matches(BlockState blockState, BlockPos pos, Level level) {
        List<BlockStatePredicate> pred = this.predicates.get();
        if (AGoodPlace.isHardcodedBlackList(blockState)) {
            return false;
        }
        if (pred.isEmpty()) {
            return true;
        }
        return pred.stream().allMatch(p -> p.test(blockState, pos, level));
    }

    static Codec<Float> floatRangeExclusive(float minExclusive, float maxExclusive) {
        Function<Float, DataResult<Float>> checker = AnimationParameters.checkRange(Float.valueOf(minExclusive), Float.valueOf(maxExclusive));
        return Codec.FLOAT.flatXmap(checker, checker);
    }

    static <N extends Number> Function<N, DataResult<N>> checkRange(N minExclusive, N maxExclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minExclusive) > 0 && ((Comparable)((Object)value)).compareTo(maxExclusive) < 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Value " + String.valueOf(value) + " outside of range (" + String.valueOf(minExclusive) + ":" + String.valueOf(maxExclusive) + ")", (Object)value);
        };
    }

    protected static class LazyList<T, O> {
        private final Codec<O> codec;
        private final Dynamic<T> toDecode;
        private List<O> objects = List.of();

        public LazyList(Dynamic<T> toDecode, Codec<O> codec) {
            this.toDecode = toDecode;
            this.codec = codec;
        }

        public static <H> Codec<LazyList<?, H>> codec(Codec<H> codec) {
            return Codec.PASSTHROUGH.xmap(o -> new LazyList(o, codec), o -> o.toDecode);
        }

        public List<O> get() {
            return this.objects;
        }

        protected void lazyInit(RegistryAccess registryAccess) {
            this.objects = List.of();
            DataResult res = this.codec.listOf().decode((DynamicOps)RegistryOps.m_255058_((DynamicOps)this.toDecode.getOps(), (HolderLookup.Provider)registryAccess), this.toDecode.getValue());
            try {
                this.objects = (List)((Pair)res.getOrThrow(false, s -> AGoodPlace.LOGGER.error("Could not decode block list for placement animation - error: {}", s))).getFirst();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

