/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.pack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import org.jetbrains.annotations.Nullable;

public class AnimationsManager
extends SimpleJsonResourceReloadListener {
    private static final List<AnimationParameters> ANIMATIONS = new ArrayList<AnimationParameters>();

    public AnimationsManager() {
        super(new Gson(), "placement_animations");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        ANIMATIONS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            AnimationParameters effect = (AnimationParameters)((Pair)AnimationParameters.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> AGoodPlace.LOGGER.warn("Could not decode Block Placement Animation with json id {} - error: {} - json: {}", (Object)id, errorMsg, (Object)j))).getFirst();
            ANIMATIONS.add(effect);
        }
        ANIMATIONS.sort((a, b) -> Integer.compare(b.priority(), a.priority()));
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            AnimationsManager.populateTags(level.m_9598_());
        }
    }

    @Nullable
    public static AnimationParameters getAnimation(BlockState blockState, BlockPos pos, Level level) {
        if (AGoodPlace.IS_DEV) {
            // empty if block
        }
        for (AnimationParameters animation : ANIMATIONS) {
            if (!animation.matches(blockState, pos, level)) continue;
            return animation;
        }
        return null;
    }

    public static void populateTags(RegistryAccess registryAccess) {
        for (AnimationParameters v : ANIMATIONS) {
            v.predicates().lazyInit(registryAccess);
        }
    }
}

