/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.a_good_place.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import nl.enjarai.a_good_place.AGoodPlace;
import nl.enjarai.a_good_place.pack.AnimationParameters;
import nl.enjarai.a_good_place.pack.AnimationsManager;
import nl.enjarai.a_good_place.particles.ConfiguredPlacingParticle;
import nl.enjarai.a_good_place.particles.PlacingBlockParticle;

public class BlocksParticlesManager {
    protected static final Map<BlockPos, PlacingBlockParticle> PARTICLES = new HashMap<BlockPos, PlacingBlockParticle>();
    private static final Set<BlockPos> HIDDEN_BLOCKS = new CopyOnWriteArraySet<BlockPos>();

    public static void addParticle(BlockState state, BlockPos pos, ClientLevel level, Direction face, Player player, InteractionHand hand) {
        Camera camera;
        AnimationParameters param = AnimationsManager.getAnimation(state, pos, (Level)level);
        if (param != null && (camera = Minecraft.m_91087_().f_91063_.m_109153_()).m_90583_().m_82557_(pos.m_252807_()) <= 1024.0) {
            boolean isJustModel;
            ConfiguredPlacingParticle p = new ConfiguredPlacingParticle(level, pos, face, player, hand, param);
            PlacingBlockParticle old = PARTICLES.put(pos, p);
            if (old != null) {
                old.m_107274_();
            }
            boolean bl = isJustModel = state.m_60799_() == RenderShape.MODEL;
            if (isJustModel) {
                p.canRender = true;
                BlocksParticlesManager.hideBlock(pos);
            } else {
                p.canRender = false;
            }
            if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)p);
            }
        }
    }

    public static void hideBlock(BlockPos pos) {
        HIDDEN_BLOCKS.add(pos);
    }

    public static boolean isBlockHidden(BlockPos pos) {
        return HIDDEN_BLOCKS.contains(pos);
    }

    public static void unHideBlock(BlockPos pos) {
        boolean success = HIDDEN_BLOCKS.remove(pos);
        PARTICLES.remove(pos);
        if (success) {
            BlocksParticlesManager.markBlockForRender(pos);
        }
    }

    private static void markBlockForRender(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 2);
    }

    public static void tickParticles(ClientLevel level) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES) {
            return;
        }
        Iterator<Map.Entry<BlockPos, PlacingBlockParticle>> iterator = PARTICLES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, PlacingBlockParticle> entry = iterator.next();
            PlacingBlockParticle p = entry.getValue();
            p.m_5989_();
            if (p.m_107276_()) continue;
            iterator.remove();
        }
    }

    public static void renderParticles(PoseStack poseStack, float tickDelta) {
        if (AGoodPlace.RENDER_AS_VANILLA_PARTICLES || PARTICLES.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        RenderSystem.enableDepthTest();
        PoseStack poseStack2 = RenderSystem.getModelViewStack();
        poseStack2.m_85836_();
        poseStack2.m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        for (PlacingBlockParticle p : PARTICLES.values()) {
            p.m_5744_(null, camera, tickDelta);
        }
        bufferSource.m_109911_();
        poseStack2.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public static void modifyTilePosition(BlockPos pos, PoseStack pose, float partialTicks) {
        PlacingBlockParticle particle = PARTICLES.get(pos);
        if (particle != null) {
            particle.applyAnimation(pose, partialTicks);
        }
    }

    public static void clear() {
        PARTICLES.clear();
        HIDDEN_BLOCKS.clear();
    }
}

