/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.embeds;

import earth.terrarium.argonauts.client.screens.chat.embeds.Embeder;
import earth.terrarium.argonauts.client.screens.chat.embeds.ImageEmbeder;
import earth.terrarium.argonauts.client.screens.chat.embeds.SpotifyTrackEmbeder;
import earth.terrarium.argonauts.client.screens.chat.embeds.YoutubeVideoEmbeder;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;

public class EmbedHandler {
    private static final Map<String, Embeder> HANDLERS = new HashMap<String, Embeder>();

    public static void register(String domain, Embeder handler) {
        HANDLERS.put(domain, handler);
    }

    public static void handle(GuiGraphics graphics, String url) {
        try {
            URI uri = URI.create(url);
            Embeder handler = HANDLERS.get(uri.getHost());
            if (handler != null) {
                handler.handle(graphics, uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        EmbedHandler.register("i.imgur.com", new ImageEmbeder());
        EmbedHandler.register("media.tenor.com", new ImageEmbeder());
        EmbedHandler.register("media.discordapp.net", new ImageEmbeder());
        EmbedHandler.register("cdn.discordapp.com", new ImageEmbeder());
        EmbedHandler.register("youtube.com", new YoutubeVideoEmbeder());
        EmbedHandler.register("www.youtube.com", new YoutubeVideoEmbeder());
        EmbedHandler.register("youtu.be", new YoutubeVideoEmbeder());
        EmbedHandler.register("www.youtu.be", new YoutubeVideoEmbeder());
        EmbedHandler.register("open.spotify.com", new SpotifyTrackEmbeder());
    }
}

